/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.exception;

import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import cn.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@RestControllerAdvice
@Order(value=1)
public class ValidExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ValidExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ReturnVO handleValidException(MethodArgumentNotValidException e) {
        String defaultMessage = Objects.requireNonNull(e.getBindingResult().getFieldError()).getDefaultMessage();
        return new ReturnVO(ReturnEnum.FAILED.getCode(), defaultMessage);
    }

    @ExceptionHandler(value={Exception.class})
    public ReturnVO<Void> exceptionHandler(Exception e) {
        log.error(ReturnEnum.FAILED.getMessage(), (Throwable)e);
        return new ReturnVO(ReturnEnum.FAILED.getCode(), ReturnEnum.FAILED.getMessage());
    }

    @ExceptionHandler(value={BaseBusinessException.class})
    @ResponseBody
    public ReturnVO<Void> businessExceptionHandler(BaseBusinessException e) {
        log.error(e.getMessage(), (Throwable)e);
        return new ReturnVO(e.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ReturnVO<Void> handlerMaxUploadFile(MaxUploadSizeExceededException ex) {
        String msg = "\u6587\u4ef6\u4e0a\u4f20\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc710MB\uff01";
        log.warn(msg);
        return new ReturnVO("400", msg);
    }
}

