/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.gatewayimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.gateway.OrgGateway;
import com.cicv.foton.admin.domain.system.Org;
import com.cicv.foton.admin.gatewayimpl.rmdb.OrgDao;
import com.cicv.foton.admin.utils.CodeUtils;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrgGatewayImpl
implements OrgGateway {
    @Autowired
    private OrgDao orgDao;

    public void addOrg(Org org, Org parent) {
        org.setCode(this.generateOrgCode(parent));
        if (this.orgDao.insert(org) < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u5931\u8d25\u3002");
        }
    }

    public Org selectById(Long id) {
        return (Org)this.orgDao.selectById(id);
    }

    public List<Org> selectList(QueryWrapper<Org> qw) {
        return this.orgDao.selectList((Wrapper)qw);
    }

    public void updateById(Org org) {
        this.orgDao.updateById(org);
    }

    public Long orgUserInfo(Long id) {
        return this.orgDao.OrgUserInfo(id);
    }

    public Long orgSubclassInfo(Long id) {
        return this.orgDao.OrgSubclassInfo(id);
    }

    public int deleteBatchIds(List<Long> ids) {
        return this.orgDao.deleteBatchIds(ids);
    }

    public Org selectOne(QueryWrapper<Org> qw2) {
        return (Org)this.orgDao.selectOne((Wrapper)qw2);
    }

    public Integer deleteById(Long id) {
        return this.orgDao.deleteById(id);
    }

    private String generateOrgCode(Org parent) {
        QueryWrapper wrapper = new QueryWrapper();
        if (parent == null) {
            wrapper.isNull((Object)"parent_id");
        } else {
            wrapper.eq((Object)"parent_id", (Object)parent.getId());
        }
        wrapper.orderByDesc((Object)"code");
        wrapper.last("limit 1");
        Org last = (Org)this.orgDao.selectOne((Wrapper)wrapper);
        if (last != null) {
            return CodeUtils.generateSameLevelCode(last.getCode());
        }
        if (parent != null) {
            return CodeUtils.generateNextLevelCode(parent.getCode());
        }
        return CodeUtils.generateNextLevelCode("");
    }
}

