/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.domain.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectMapper objectMapper_NON_NULL = new ObjectMapper();

    private JSONUtils() {
    }

    public static ObjectMapper getInstance() {
        return objectMapper;
    }

    public static String beanToJson(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)objectMapper.convertValue(fromValue, toValueType);
    }

    public static String beanNoNullToJson(Object obj) {
        try {
            return objectMapper_NON_NULL.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T jsonToBean(String jsonStr, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(jsonStr, clazz);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> Map<String, Object> jsonToMap(String jsonStr) throws Exception {
        return (Map)objectMapper.readValue(jsonStr, Map.class);
    }

    public static <T> Map<String, T> jsonToMap(String jsonStr, Class<T> clazz) throws Exception {
        Map map = (Map)objectMapper.readValue(jsonStr, new TypeReference<Map<String, T>>(){});
        HashMap result = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), JSONUtils.mapToBean((Map)entry.getValue(), clazz));
        }
        return result;
    }

    public static <T> List<T> jsonToList(String jsonArrayStr, Class<T> clazz) throws Exception {
        List list = (List)objectMapper.readValue(jsonArrayStr, new TypeReference<List<T>>(){});
        ArrayList<T> result = new ArrayList<T>();
        for (Map map : list) {
            result.add(JSONUtils.mapToBean(map, clazz));
        }
        return result;
    }

    public static <T> T mapToBean(Map map, Class<T> clazz) {
        return (T)objectMapper.convertValue((Object)map, clazz);
    }

    static {
        objectMapper_NON_NULL.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

