/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.domain.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    private static final SimpleDateFormat ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat ymdhm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat ymd_2 = new SimpleDateFormat("yyyy.MM.dd");
    private static final SimpleDateFormat ymd000 = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
    private static final SimpleDateFormat hm = new SimpleDateFormat("HH:mm");
    private static final SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat yyyyMMddHHmm = new SimpleDateFormat("yyyyMMddHHmm");
    public static final String[] DATE_FORMAT = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-d HH:mm:ss", "yyyy-M-dd HH:mm:ss", "yyyy-M-d HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-d", "yyyy-M-dd", "yyyy-M-d", "yyyy-MM-dd HH:mm", "yyyy-MM-d HH:mm", "yyyy-M-dd HH:mm", "yyyy-M-d HH:mm", "yyyy/MM/dd HH:mm:ss", "yyyy/M/d HH:mm:ss", "yyyy/MM/d HH:mm:ss", "yyyy/M/dd HH:mm:ss", "yyyy/MM/dd", "yyyy/MM/d", "yyyy/M/dd", "yyyy/M/d", "yyyy/MM", "yyyy/M", "yyyy-MM", "yyyy-M"};

    private DateUtil() {
    }

    public static Date getDateByStr(String str) {
        String[] dateFormat;
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        for (String formate : dateFormat = DATE_FORMAT) {
            Date validDate = DateUtil.isValidDate(str, formate);
            if (null == validDate) continue;
            return validDate;
        }
        return null;
    }

    public static Date isValidDate(String str, String format) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            sdf.setLenient(false);
            if (str.length() == format.length()) {
                date = sdf.parse(str);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Date strToDate(String time) {
        try {
            return ymdhms.parse(time);
        }
        catch (ParseException e) {
            log.error("\u8f6c\u6362\u65e5\u671f\u683c\u5f0f\u9519\u8bef:{}", (Throwable)e);
            return null;
        }
    }

    public static String strToDateToStr(String time) {
        try {
            return ymdhms.format(yyyyMMddHHmm.parse(time));
        }
        catch (ParseException e) {
            log.error("\u8f6c\u6362\u65e5\u671f\u683c\u5f0f\u9519\u8bef:{}", (Throwable)e);
            return null;
        }
    }

    public static String getTimeStr(Date time) {
        return ymd.format(time);
    }

    public static String getTimeStrByFormat(Date time, SimpleDateFormat format) {
        return format.format(time);
    }

    public static String getTimeStr(Date time, SimpleDateFormat format) {
        return format.format(time);
    }

    public static String getNowStr() {
        return ymdhms.format(new Date());
    }

    public static String getNowStrTwo() {
        return yyyyMMddHHmmss.format(new Date());
    }

    public static String dateToStrHm(Date date) {
        return hm.format(date);
    }

    public static String getParseTime(int cal, int num) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(cal, num);
        return ymdhms.format(calendar.getTime());
    }

    public static String getParseTimeymd(int cal, int num) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(cal, num);
        return ymd.format(calendar.getTime());
    }

    public static String addDay(String time, int day) throws ParseException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        Date timeNow = sf.parse(time);
        Calendar c = Calendar.getInstance();
        c.setTime(timeNow);
        c.add(5, day);
        return sf.format(c.getTime());
    }

    public static String getParseTimeByCustom(int cal, int num, String formatter) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(cal, num);
        return new SimpleDateFormat(formatter).format(calendar.getTime());
    }

    public static String tamToStr(Long time) {
        return ymdhms.format(time);
    }

    public static String dateCal(int n) {
        Calendar ca = Calendar.getInstance();
        ca.add(12, n);
        Date time = ca.getTime();
        return ymdhm.format(time);
    }

    public static Date dateCal(int type, int n) {
        Date parse = null;
        Calendar ca = Calendar.getInstance();
        ca.add(type, n);
        Date time = ca.getTime();
        try {
            parse = ymd000.parse(ymd000.format(time));
        }
        catch (ParseException e) {
            log.error("\u8f6c\u6362\u65f6\u95f4\u5f02\u5e38");
        }
        return parse;
    }

    public static String localDateToStr(LocalDateTime localDateTime) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00");
        return df.format(localDateTime);
    }

    public static String localMonthToStr(LocalDateTime localDateTime) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
        return df.format(localDateTime);
    }

    public static LocalDateTime localDateStrTolocalDate(String str) {
        String time = str.replace("T", " ").replace("+08:00", "");
        return LocalDateTime.parse(time, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    public static String getOneDayOfYear() {
        String newTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy"));
        return newTime;
    }

    public static LocalDateTime getFirstDayOfThisMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        return LocalDateTime.parse(ymd000.format(cal.getTime()), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static Date dateCal(Date time, int type, int n) {
        Date parse = null;
        Calendar ca = Calendar.getInstance();
        ca.setTime(time);
        ca.add(type, n);
        Date date = ca.getTime();
        try {
            parse = ymdhms.parse(ymdhms.format(date));
        }
        catch (ParseException e) {
            log.error("\u8f6c\u6362\u65f6\u95f4\u5f02\u5e38");
        }
        return parse;
    }

    public static Date getTodayStartTime(Date time) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(time);
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return ca.getTime();
    }

    public static Date getTodayEndTime(Date time) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(time);
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        ca.set(14, 999);
        return ca.getTime();
    }

    public static int daysBetween(String startdate, String enddate) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ymd.parse(startdate));
        long start = calendar.getTimeInMillis();
        calendar.setTime(ymd.parse(enddate));
        long end = calendar.getTimeInMillis();
        long betweendays = (end - start) / 86400000L;
        int days = Integer.parseInt(String.valueOf(betweendays));
        return days;
    }

    public static String getNowStrYmdhm(Date d) {
        return yyyyMMddHHmm.format(d);
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getTimeStrByFormat(new Date(), ymd_2));
    }
}

