/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.domain.utils;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class AuthUtils {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
    private final String appuser;
    private final String appkey;
    private final String appinfo;

    public AuthUtils(String appuser, String appkey, String appinfo) {
        this.appuser = appuser;
        this.appkey = appkey;
        this.appinfo = appinfo;
    }

    public String getResponseFromServer(String url, Map<String, Object> params) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        this.createSignHeader((HttpUriRequest)httpPost, params);
        JSONObject object = new JSONObject(params);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(object.toString().getBytes(), ContentType.APPLICATION_JSON));
        return this.execute((HttpUriRequest)httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(HttpUriRequest request) throws Exception {
        String string;
        CloseableHttpClient client = null;
        CloseableHttpResponse resp = null;
        try {
            client = HttpClientBuilder.create().build();
            resp = client.execute(request);
            string = EntityUtils.toString((HttpEntity)resp.getEntity());
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(resp);
            HttpClientUtils.closeQuietly((HttpClient)client);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)resp);
        HttpClientUtils.closeQuietly((HttpClient)client);
        return string;
    }

    private void createSignHeader(HttpUriRequest request, Map<String, Object> params) throws Exception {
        request.addHeader("appuser", this.appuser);
        String randomcode = RandomStringUtils.random((int)10, (boolean)true, (boolean)true);
        request.addHeader("randomcode", randomcode);
        Calendar now = Calendar.getInstance();
        String timestamp = sdf.format(now.getTime());
        request.addHeader("timestamp", timestamp);
        String data = StringUtils.join((Object[])new String[]{this.appuser, randomcode, timestamp});
        String encodekey = DigestUtils.sha256Hex((String)StringUtils.join((Object[])new String[]{data, "{", this.appkey, "}"}));
        request.addHeader("encodekey", encodekey);
        JSONObject object = new JSONObject(params);
        String paramData = StringUtils.join((Object[])new String[]{object.toString(), "&", this.appkey});
        String signature = DigestUtils.md5Hex((String)paramData);
        request.addHeader("sign", signature);
        request.addHeader("appinfo", this.appinfo);
        request.addHeader("Content-Type", "application/json");
    }
}

