/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cicv.foton.admin.api.IRoleService;
import com.cicv.foton.admin.api.IUserService;
import com.cicv.foton.admin.commond.admin.AdminUserGetUserByPhoneCmdExe;
import com.cicv.foton.admin.commond.messageBox.MessageAgreeCmdExe;
import com.cicv.foton.admin.commond.messageBox.MessageMessageCountCmdExe;
import com.cicv.foton.admin.commond.messageBox.MessagePageCmdExe;
import com.cicv.foton.admin.commond.user.UserAddCmdExe;
import com.cicv.foton.admin.commond.user.UserDeleteUserCmdExe;
import com.cicv.foton.admin.commond.user.UserGetUserCmdExe;
import com.cicv.foton.admin.commond.user.UserPageCmdExe;
import com.cicv.foton.admin.commond.user.UserRegistCmdExe;
import com.cicv.foton.admin.commond.user.UserResetPasswordCmdExe;
import com.cicv.foton.admin.commond.user.UserResetPasswordVerifyCodeCmdExe;
import com.cicv.foton.admin.commond.user.UserSendCodeForUpdatePhoneCmdExe;
import com.cicv.foton.admin.commond.user.UserSynTenantCmdExe;
import com.cicv.foton.admin.commond.user.UserUpdatePasswordCmdExe;
import com.cicv.foton.admin.commond.user.UserUpdatePhoneCheckCmdExe;
import com.cicv.foton.admin.commond.user.UserUpdatePhoneCmdExe;
import com.cicv.foton.admin.commond.user.UserUpdateUserCmdExe;
import com.cicv.foton.admin.domain.system.AdminMessage;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.AdminUserCmd;
import com.cicv.foton.admin.dto.MessageBoxCmd;
import com.cicv.foton.admin.dto.ReserPasswprdCmd;
import com.cicv.foton.admin.dto.UserCmd;
import com.cicv.foton.admin.dto.UserPasswordCmd;
import com.cicv.foton.admin.dto.UserRegistCmd;
import com.cicv.foton.admin.dto.UserUpdatePhoneCmd;
import com.cicv.foton.admin.gatewayimpl.rmdb.TenantInfoMapper;
import com.cicv.foton.admin.gatewayimpl.rmdb.UserDao;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
extends ServiceImpl<UserDao, User>
implements IUserService {
    @Resource
    private IRoleService roleService;
    @Resource
    TenantInfoMapper tenantInfoMapper;
    @Value(value="${casUserSyncUrl:}")
    private String casUserSyncUrl;
    @Value(value="${domainName:}")
    private String domainName;
    @Value(value="${systemid:}")
    private String systemid;
    @Autowired
    private RedisDao redisDao;
    @Autowired
    private UserPageCmdExe userQueryCmdExe;
    @Autowired
    private UserAddCmdExe addCmdExe;
    @Resource
    private UserUpdateUserCmdExe userUpdateUserCmdExe;
    @Resource
    private UserDeleteUserCmdExe userDeleteUserCmdExe;
    @Resource
    private UserUpdatePasswordCmdExe userUpdatePasswordCmdExe;
    @Resource
    private UserResetPasswordCmdExe userResetPasswordCmdExe;
    @Resource
    private UserGetUserCmdExe userGetUserCmdExe;
    @Resource
    private UserSynTenantCmdExe userSynTenantCmdExe;
    @Resource
    private UserRegistCmdExe userRegistCmdExe;
    @Resource
    private UserResetPasswordVerifyCodeCmdExe userResetPasswordVerifyCodeCmdExe;
    @Resource
    private UserUpdatePhoneCheckCmdExe uUserUpdatePhoneCheckCmdExe;
    @Resource
    private UserSendCodeForUpdatePhoneCmdExe userSendCodeForupdatePhoneCmdExe;
    @Resource
    private UserUpdatePhoneCmdExe userUpdatePhoneCmdExe;
    @Resource
    AdminUserGetUserByPhoneCmdExe adminUserGetUserByPhoneCmdExe;
    @Resource
    MessagePageCmdExe messageBoxPageCmdExe;
    @Resource
    MessageAgreeCmdExe messageBoxIsAgreeCmdExe;
    @Resource
    MessageMessageCountCmdExe messageBoxIsMessageCountCmdExe;

    public IPage<UserCmd> page(UserCmd user) {
        return this.userQueryCmdExe.execute(user);
    }

    public ReturnVO<Boolean> addUser(User user) {
        return this.addCmdExe.execute(user);
    }

    private Boolean userVerification(User user) {
        String regex1 = "^[-a-z0-9A-Z_\u4e00-\u9fa5]+$";
        boolean matches = Pattern.matches(regex1, user.getUsername());
        if (!matches && user.getUsername().length() < 100) {
            throw new BaseBusinessException("400", "\u7528\u6237\u53ea\u80fd\u5305\u542b\u4e2d\u6587\u3001\u82f1\u6587\u5b57\u6bcd\u5927\u5c0f\u5199\u3001\u963f\u62c9\u4f2f\u6570\u5b57\uff0c\u4e2d\u6a2a\u7ebf\u3001\u4e0b\u6a2a\u7ebf\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26!");
        }
        return true;
    }

    public ReturnVO<Boolean> updateUser(User user) {
        return this.userUpdateUserCmdExe.execute(user);
    }

    @Transactional(rollbackOn={Exception.class})
    public ReturnVO<Boolean> deleteUser(UserCmd user) {
        return this.userDeleteUserCmdExe.execute(user);
    }

    public User getUser(UserCmd userCmd) {
        return this.userGetUserCmdExe.execute(userCmd);
    }

    public void updatePassword(UserPasswordCmd cmd) {
        this.userUpdatePasswordCmdExe.execute(cmd);
    }

    public void resetPassword(UserPasswordCmd cmd) {
        this.userResetPasswordCmdExe.execute(cmd);
    }

    public void synTenant() {
        this.userSynTenantCmdExe.execute();
    }

    public void userRegist(UserRegistCmd cmd) {
        this.userRegistCmdExe.execute(cmd);
    }

    public String resetPasswordVerifyCode(ReserPasswprdCmd cmd) {
        return this.userResetPasswordVerifyCodeCmdExe.execute(cmd);
    }

    public ReturnVO updatePhoneCheck(UserUpdatePhoneCmd cmd) {
        return this.uUserUpdatePhoneCheckCmdExe.execute(cmd);
    }

    public void sendCodeForupdatePhone(UserUpdatePhoneCmd cmd) {
        this.userSendCodeForupdatePhoneCmdExe.execute(cmd);
    }

    public void updatePhone(UserUpdatePhoneCmd cmd) {
        this.userUpdatePhoneCmdExe.execute(cmd);
    }

    public IPage<AdminMessage> pageMessageBox(MessageBoxCmd cmd) {
        return this.messageBoxPageCmdExe.execute(cmd);
    }

    public AdminUser getUserByPhone(AdminUserCmd cmd) {
        return this.adminUserGetUserByPhoneCmdExe.execute(cmd);
    }

    public void isAgree(MessageBoxCmd cmd) {
        this.messageBoxIsAgreeCmdExe.execute(cmd);
    }

    public Long messageCount(MessageBoxCmd cmd) {
        return this.messageBoxIsMessageCountCmdExe.execute(cmd);
    }
}

