/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.IsConfimEnum;
import com.cicv.foton.admin.domain.enums.IsEnabledEnum;
import com.cicv.foton.admin.domain.enums.IsMasterEnum;
import com.cicv.foton.admin.domain.enums.ResultEnum;
import com.cicv.foton.admin.domain.enums.SelectEnum;
import com.cicv.foton.admin.domain.enums.UserTypeEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.gateway.DictGateway;
import com.cicv.foton.admin.domain.gateway.PermInfoGateway;
import com.cicv.foton.admin.domain.gateway.ServiceResourceGateway;
import com.cicv.foton.admin.domain.gateway.TenantGateway;
import com.cicv.foton.admin.domain.system.AdminMember;
import com.cicv.foton.admin.domain.system.AdminMessage;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.domain.system.Dict;
import com.cicv.foton.admin.domain.system.PermResourceRel;
import com.cicv.foton.admin.domain.system.ServiceResource;
import com.cicv.foton.admin.domain.system.Tenant;
import com.cicv.foton.admin.domain.system.dataobject.BussDomainApplyDO;
import com.cicv.foton.admin.dto.clientobject.BussDomainAppInfoCO;
import com.cicv.foton.admin.dto.clientobject.BussDomainCO;
import com.cicv.foton.admin.dto.clientobject.BussDomainServiceInfoCO;
import com.cicv.foton.admin.dto.clientobject.LoginCO;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.cicv.foton.common.sdk.utils.JwtTokenUtils;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.core.utils.TreeUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class CommonService {
    private static final Logger log = LoggerFactory.getLogger(CommonService.class);
    @Resource
    DictGateway dictGateway;
    @Autowired
    AdminUserGateway adminUserGateway;
    @Autowired
    PermInfoGateway permInfoGateway;
    @Autowired
    AdminMemberGateway adminMemberGateway;
    @Resource
    TenantGateway tenantGateway;
    @Resource
    ServiceResourceGateway serviceResourceGateway;
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Autowired
    RedisDao redisDao;
    @Value(value="${uploadservice.fileserver}")
    private String fileserver;

    public Map<String, List<Dict>> getDic() {
        List dictList = this.dictGateway.selectDictList((QueryWrapper)new QueryWrapper().in((Object)"dict_type", Arrays.asList("row_operator", "data_type")));
        final List rowOperatorList = dictList.stream().filter(m -> Objects.equals("row_operator", m.getDictType())).collect(Collectors.toList());
        if (rowOperatorList.isEmpty()) {
            throw new BaseBusinessException(ResultEnum.PACKAGE_MODEL_ROW_OPERATOR.getCode(), ResultEnum.PACKAGE_MODEL_ROW_OPERATOR.getMessage());
        }
        final List dataTypeList = dictList.stream().filter(m -> Objects.equals("data_type", m.getDictType())).collect(Collectors.toList());
        if (rowOperatorList.isEmpty()) {
            throw new BaseBusinessException(ResultEnum.PACKAGE_MODEL_ROW_DATA.getCode(), ResultEnum.PACKAGE_MODEL_ROW_DATA.getMessage());
        }
        return new HashMap<String, List<Dict>>(){
            {
                this.put("rowOperator", rowOperatorList);
                this.put("dataType", dataTypeList);
            }
        };
    }

    public User getCurrentUser() {
        User user = SdkContext.getCurrentUser();
        if (Objects.isNull(user)) {
            throw new BaseBusinessException(ResultEnum.TOKEN_IS_NULL.getCode(), ResultEnum.TOKEN_IS_NULL.getMessage());
        }
        return user;
    }

    public Long getUserIdByToken(String token) {
        Map claims = JwtTokenUtils.getClaims((String)token);
        if (claims.isEmpty() || Objects.isNull(claims.get("userId"))) {
            throw new BaseBusinessException(ResultEnum.TOKEN_ERROR3.getCode(), ResultEnum.TOKEN_ERROR3.getMessage());
        }
        return Long.valueOf(String.valueOf(claims.get("userId")));
    }

    public void isExceedMemberCapacity(Long tenantId) {
        Tenant tenant = this.tenantGateway.selectById(tenantId);
        if (Objects.isNull(tenant)) {
            throw new BaseBusinessException(CommonEnum.TENANT_IS_NULL.getCode(), CommonEnum.TENANT_IS_NULL.getMessage());
        }
        Long memberCapacity = tenant.getMemberCapacity();
        long count = this.adminMemberGateway.queryAdminMemberCountByTenant((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminMember::getIsConfirm, (Object)IsConfimEnum.AGREE.getStatus())).eq(CommonEntity::getTenantId, (Object)tenantId));
        if (count > memberCapacity || count == memberCapacity) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_EXCEED.getCode(), CommonEnum.MEMBER_IS_EXCEED.getMessage());
        }
    }

    public void buildLoginInfo(LoginCO loginCO, AdminUser adminUser, Long MemberId) {
        AdminMember adminMember;
        Long tenantId = null;
        Long memberId = null;
        if (!Objects.isNull(MemberId) && !Objects.isNull(adminMember = this.adminMemberGateway.getAdminMemberByWrapper((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)MemberId)).eq(AdminMember::getIsEnabled, (Object)IsEnabledEnum.ENABLED.getStatus())))) {
            tenantId = adminMember.getTenantId();
            memberId = adminMember.getId();
            adminUser.setOrgId(adminMember.getOrgId());
            this.buildUserResource(loginCO, adminMember);
        }
        loginCO.setTenantId(tenantId);
        loginCO.setToken(this.generateToken(tenantId, memberId, adminUser));
    }

    public AdminUser getAdminUser(LambdaQueryWrapper<AdminUser> warpper) {
        AdminUser adminUser = this.adminUserGateway.selectUserInfo(warpper);
        if (Objects.isNull(adminUser)) {
            log.info("{}\u7528\u6237\u4e0d\u5b58\u5728", (Object)(Objects.isNull(adminUser) ? null : adminUser.getPhone()));
            throw new BaseBusinessException(CommonEnum.USER_ABSENT.getCode(), CommonEnum.USER_ABSENT.getMessage());
        }
        if (Objects.equals(IsEnabledEnum.DISABLED.getStatus(), adminUser.getIsEnabled())) {
            log.info("{}\u7528\u6237\u5df2\u505c\u7528", (Object)adminUser.getPhone());
            throw new BaseBusinessException(ReturnEnum.ERROR_USER_NOT_ENABLED);
        }
        return adminUser;
    }

    public void checkPhoneCode(String phone, String smsCodeType, String verificationCode) {
        if (StringUtils.isBlank((String)verificationCode)) {
            throw new BaseBusinessException(CommonEnum.LOGIN_PHONE_VERIFY_CODE_IS_NULL.getCode(), CommonEnum.LOGIN_PHONE_VERIFY_CODE_IS_NULL.getMessage());
        }
        String redisKey = this.getSmsCodeKey(smsCodeType, phone);
        if (!this.redisDao.hasKey(redisKey)) {
            throw new BaseBusinessException(CommonEnum.LOGIN_PHONE_VERIFY_CODE_EXPIRED.getCode(), CommonEnum.LOGIN_PHONE_VERIFY_CODE_EXPIRED.getMessage());
        }
        String code = this.redisDao.getString(redisKey);
        if (StringUtils.isBlank((String)code) || !Objects.equals(verificationCode, code)) {
            this.redisDao.del(new String[]{redisKey});
            throw new BaseBusinessException(CommonEnum.LOGIN_PHONE_VERIFY_CODE_ERROR.getCode(), CommonEnum.LOGIN_PHONE_VERIFY_CODE_ERROR.getMessage());
        }
        this.redisDao.del(new String[]{redisKey});
    }

    public void checkEmailCode(String email, String smsCodeType, String emailCode) {
        if (StringUtils.isBlank((String)emailCode)) {
            throw new BaseBusinessException(CommonEnum.LOGIN_EMAIL_VERIFY_CODE_IS_NULL.getCode(), CommonEnum.LOGIN_EMAIL_VERIFY_CODE_IS_NULL.getMessage());
        }
        String redisKey = this.getEmailCodeKey(smsCodeType, email);
        if (!this.redisDao.hasKey(redisKey)) {
            throw new BaseBusinessException(CommonEnum.LOGIN_EMAIL_VERIFY_CODE_EXPIRED.getCode(), CommonEnum.LOGIN_EMAIL_VERIFY_CODE_EXPIRED.getMessage());
        }
        String code = this.redisDao.getString(redisKey);
        if (StringUtils.isBlank((String)code) || !Objects.equals(emailCode, code)) {
            this.redisDao.del(new String[]{redisKey});
            throw new BaseBusinessException(CommonEnum.LOGIN_EMAIL_VERIFY_CODE_EXPIRED.getCode(), CommonEnum.LOGIN_EMAIL_VERIFY_CODE_EXPIRED.getMessage());
        }
        this.redisDao.del(new String[]{redisKey});
    }

    public String generateToken(Long tenantId, Long memberId, AdminUser adminUser) {
        User user = new User();
        BeanUtils.copyProperties((Object)adminUser, (Object)user);
        user.setTenantId(tenantId);
        user.setUsername(adminUser.getUserName());
        user.setRealName(adminUser.getRealName());
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("userId", adminUser.getId());
        claims.put("tenantId", tenantId);
        claims.put("memberId", memberId);
        claims.put("username", user.getUsername());
        claims.put("orgId", adminUser.getOrgId());
        String jwtToken = JwtTokenUtils.generateToken((String)user.getUsername(), claims);
        AuthorityUtils.putCurrentUser((String)jwtToken, (UserDetails)user);
        return jwtToken;
    }

    public void buildUserResource(LoginCO loginCO, AdminMember adminMember) {
        Long memberId = adminMember.getId();
        List bussDomainApply = new ArrayList();
        ArrayList<BussDomainCO> list = new ArrayList<BussDomainCO>();
        if (Objects.equals(IsMasterEnum.TENANT_USER.getMasterType(), adminMember.getIsMaster())) {
            bussDomainApply = this.adminMemberGateway.getBussDomainByMemberId(memberId);
        } else if (Objects.equals(IsMasterEnum.TENANT_ADMIN.getMasterType(), adminMember.getIsMaster())) {
            bussDomainApply = this.adminMemberGateway.getBussDomainByTenantId(adminMember.getTenantId());
        }
        this.buildBussDomain(bussDomainApply, list, memberId);
        loginCO.setBussDomainList(list);
    }

    private void buildBussDomain(List<BussDomainApplyDO> bussDomainApply, List<BussDomainCO> list, Long memberId) {
        ArrayList allSourceList = new ArrayList();
        Map<Long, List<BussDomainApplyDO>> map = bussDomainApply.stream().collect(Collectors.groupingBy(BussDomainApplyDO::getDictBusinessDomainId));
        map.entrySet().stream().forEach(entry -> {
            BussDomainCO bussDomainCO = new BussDomainCO();
            ArrayList internalBussDomain = new ArrayList();
            ArrayList externalBussDomain = new ArrayList();
            bussDomainCO.setDictBusinessDomainId((Long)entry.getKey());
            bussDomainCO.setInternalBussDomain(internalBussDomain);
            bussDomainCO.setExternalBussDomain(externalBussDomain);
            list.add(bussDomainCO);
            List bussDomainApplyList = (List)entry.getValue();
            Map<Long, List<BussDomainApplyDO>> bussDomainApplyMap = bussDomainApplyList.stream().collect(Collectors.groupingBy(BussDomainApplyDO2 -> BussDomainApplyDO2.getAppId()));
            bussDomainApplyMap.entrySet().stream().forEach(e -> {
                List bussDomainApplyResourceList = (List)e.getValue();
                if (!bussDomainApplyResourceList.isEmpty()) {
                    BussDomainApplyDO bussDomainApp = (BussDomainApplyDO)bussDomainApplyResourceList.get(0);
                    Integer appType = bussDomainApp.getAppType();
                    BussDomainAppInfoCO bussDomainAppInfoCO = new BussDomainAppInfoCO();
                    BeanUtils.copyProperties((Object)bussDomainApp, (Object)bussDomainAppInfoCO);
                    bussDomainAppInfoCO.setAppLogo(StringUtils.isBlank((String)bussDomainAppInfoCO.getAppLogo()) ? null : this.fileserver + bussDomainAppInfoCO.getAppLogo());
                    ArrayList serviceList = new ArrayList();
                    bussDomainAppInfoCO.setServiceList(serviceList);
                    Map<Long, List<BussDomainApplyDO>> bussDomainSrvMap = bussDomainApplyResourceList.stream().collect(Collectors.groupingBy(BussDomainApplyDO2 -> BussDomainApplyDO2.getSrvId()));
                    bussDomainSrvMap.entrySet().stream().forEach(eSrv -> {
                        if (!bussDomainApplyResourceList.isEmpty()) {
                            BussDomainServiceInfoCO bussDomainServiceInfoCO = new BussDomainServiceInfoCO();
                            BeanUtils.copyProperties(bussDomainApplyResourceList.get(0), (Object)bussDomainServiceInfoCO);
                            bussDomainServiceInfoCO.setSrvLogo(StringUtils.isBlank((String)bussDomainServiceInfoCO.getSrvLogo()) ? null : this.fileserver + bussDomainServiceInfoCO.getSrvLogo());
                            ArrayList<ServiceResource> sourceList = new ArrayList<ServiceResource>();
                            ArrayList<ServiceResource> dpSourceList = new ArrayList<ServiceResource>();
                            for (BussDomainApplyDO bussDomainApplyDO : bussDomainApplyResourceList) {
                                ServiceResource serviceResource = new ServiceResource();
                                BeanUtils.copyProperties((Object)bussDomainApplyDO, (Object)serviceResource);
                                sourceList.add(serviceResource);
                                ServiceResource serviceResourceAll = new ServiceResource();
                                BeanUtils.copyProperties((Object)bussDomainApplyDO, (Object)serviceResourceAll);
                                dpSourceList.add(serviceResourceAll);
                            }
                            bussDomainServiceInfoCO.setResourceList(TreeUtils.list2Tree(sourceList));
                            allSourceList.addAll(dpSourceList);
                            serviceList.add(bussDomainServiceInfoCO);
                        }
                    });
                    if (Objects.equals(0, appType)) {
                        internalBussDomain.add(bussDomainAppInfoCO);
                    } else {
                        externalBussDomain.add(bussDomainAppInfoCO);
                    }
                }
            });
        });
        log.info("\u5f53\u524d\u7528\u6237\u8d44\u6e90\u6743\u9650\u4fe1\u606f{}", (Object)JSON.toJSONString(list));
        Map<String, List<ServiceResource>> resourceMap = allSourceList.stream().distinct().collect(Collectors.groupingBy(ServiceResource::getSrvName));
        resourceMap.entrySet().stream().forEach(e -> resourceMap.put((String)e.getKey(), TreeUtils.list2Tree((List)((List)e.getValue()))));
        if (!resourceMap.isEmpty()) {
            this.dpRedisTemplate.opsForHash().putAll((Object)("foton:application:resource:" + memberId), resourceMap);
        }
    }

    public String getSmsCodeKey(String smsCodeType, String naPhone) {
        log.info("\u83b7\u53d6\u7684\u624b\u673a\u9a8c\u8bc1\u7801\u7684key\uff1a{}", (Object)("foton:smscode:" + smsCodeType + ":" + naPhone));
        return "foton:smscode:" + smsCodeType + ":" + naPhone;
    }

    public String getEmailCodeKey(String smsCodeType, String email) {
        log.info("\u83b7\u53d6\u7684\u90ae\u7bb1\u9a8c\u8bc1\u7801\u7684key\uff1a{}", (Object)(smsCodeType + ":" + email));
        return smsCodeType + ":" + email;
    }

    public void sendEmail(String jsemail, String addressorEmail, String authorizationCode, String code) {
        try {
            String mailHost = "smtp.qq.com";
            Properties properties = new Properties();
            properties.put("mail.transport.protocol", "smtp");
            properties.put("mail.smtp.host", mailHost);
            properties.put("mail.smtp.port", (Object)25);
            properties.put("mail.smtp.auth", "true");
            properties.put("mail.smtp.ssl.enable", "false");
            properties.put("mail.debug", "true");
            Session session = Session.getInstance((Properties)properties);
            MimeMessage message = new MimeMessage(session);
            String nick = "";
            try {
                nick = MimeUtility.encodeText((String)"\u4fee\u6539\u624b\u673a\u53f7/\u90ae\u7bb1\u9a8c\u8bc1\u7801");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            StringBuffer sb = new StringBuffer("<html>   \r\n\t<head> <meta charset=\\\\utf-8\\\\ />   \r\n\t<title></title>   \r\n\t</head>  \r\n\t<body>\t \r\n\t \u90ae\u7bb1\u9a8c\u8bc1\u7801:" + code + "</br>\r\n");
            sb.append("\t   </br></html>");
            String s = sb.toString();
            message.setFrom((Address)new InternetAddress(nick + " <" + addressorEmail + ">"));
            new InternetAddress();
            InternetAddress[] internetAddressTo = InternetAddress.parse((String)jsemail);
            message.setRecipients(Message.RecipientType.TO, (Address[])internetAddressTo);
            message.setSubject("\u6807\u9898");
            message.setContent((Object)s, "text/html;charset=utf-8");
            Transport transport = session.getTransport();
            transport.connect(addressorEmail, authorizationCode);
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void savaPermRel(Long perId, Long applyId, List<ServiceResource> resourceList, List<ServiceResource> halfResourceList) {
        PermResourceRel permResourceRel = new PermResourceRel();
        permResourceRel.setPerId(perId);
        permResourceRel.setAppId(applyId);
        for (ServiceResource serviceResource : resourceList) {
            permResourceRel.setId(null);
            permResourceRel.setResId(serviceResource.getId());
            permResourceRel.setSrvId(serviceResource.getSrvId());
            permResourceRel.setTenantId(Constant.DEFAULT_TENANT);
            permResourceRel.setSelectedStatus(SelectEnum.SELECT.getSelectType());
            this.permInfoGateway.insertPremResourceRel(permResourceRel);
        }
        for (ServiceResource serviceResource : halfResourceList) {
            permResourceRel.setId(null);
            permResourceRel.setResId(serviceResource.getId());
            permResourceRel.setSrvId(serviceResource.getSrvId());
            permResourceRel.setTenantId(Constant.DEFAULT_TENANT);
            permResourceRel.setSelectedStatus(SelectEnum.HALF_SELECY.getSelectType());
            this.permInfoGateway.insertPremResourceRel(permResourceRel);
        }
    }

    public void insertMessage(Long id, Long userId, Long tenantId) {
        Tenant tenant = this.tenantGateway.selectOne((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)tenantId));
        String name = "";
        if (!Objects.isNull(tenant) && StringUtils.isNotBlank((String)tenant.getName())) {
            name = tenant.getName();
        }
        log.info("\u6210\u5458id\uff1a{}\uff0c\u7528\u6237id\uff1a{}\uff0c\u79df\u6237id\uff1a{}", new Object[]{id, userId, tenantId});
        AdminMessage adminMessage = new AdminMessage();
        adminMessage.setSourceTblName("admin_member");
        adminMessage.setMessage(String.format("%s\u7ba1\u7406\u5458\u9080\u8bf7\u60a8\u52a0\u5165%s\u79df\u6237", name, name));
        adminMessage.setRecipientId(userId);
        adminMessage.setSourceId(id);
        adminMessage.setTenantId(tenantId);
        this.adminUserGateway.insertMessage(adminMessage);
    }

    public List<Tenant> getTenatInfo(Long userId) {
        List adminTenantInfo = this.tenantGateway.getAdminTenantInfo(userId);
        for (Tenant tenant : adminTenantInfo) {
            tenant.setCoverUrl(this.getCompleteUrl(tenant.getCoverUrl()));
            tenant.setLogoUrl(this.getCompleteUrl(tenant.getLogoUrl()));
        }
        return adminTenantInfo;
    }

    public String getCompleteUrl(String url) {
        return StringUtils.isBlank((String)url) ? null : this.fileserver + url;
    }

    public AdminUser saveUserInfo(String naCode, String phone, String password) {
        AdminUser adminUser = new AdminUser();
        adminUser.setUserName(phone);
        adminUser.setPassword(password);
        adminUser.setPhone(phone);
        adminUser.setNaCode(naCode);
        adminUser.setUserType(UserTypeEnum.VISITOR.getStatus());
        adminUser.setLastLoginTime(new Date());
        this.adminUserGateway.insertAdminUser(adminUser);
        return adminUser;
    }
}

