/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.user;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.UserGateway;
import com.cicv.foton.admin.domain.gateway.UserRoleGateway;
import com.cicv.foton.admin.domain.system.UserRole;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserUpdateUserCmdExe {
    @Resource
    private UserGateway userGateway;
    @Resource
    private UserRoleGateway userRoleGateway;

    public ReturnVO<Boolean> execute(User user) {
        Long id = user.getId();
        User oldUser = this.userGateway.selectById(id);
        user.setPassword(oldUser.getPassword());
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"username", (Object)user.getUsername());
        qw.notIn((Object)"id", new Object[]{id});
        if (this.userGateway.selectUserCount(qw) > 0L) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME.getCode(), CommonEnum.PERMSSION_NAME.getMessage());
        }
        int updateFlag = this.userGateway.updateUserById(user);
        if (updateFlag < 1) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME.getCode(), CommonEnum.PERMSSION_NAME.getMessage());
        }
        this.userRoleGateway.deleteUserRoleByUserId(user.getId());
        if (user.getRoles() != null && user.getRoles().size() > 0) {
            ArrayList<UserRole> urList = new ArrayList<UserRole>();
            for (String role : user.getRoles()) {
                UserRole ur = new UserRole();
                ur.setRoleId(Long.valueOf(role).longValue());
                ur.setUserId(user.getId().longValue());
                urList.add(ur);
            }
            int insertBatchFlag = this.userRoleGateway.insertBatchUserRole(urList);
            if (insertBatchFlag < urList.size()) {
                throw new BaseBusinessException(CommonEnum.PERMSSION_NAME.getCode(), CommonEnum.PERMSSION_NAME.getMessage());
            }
        }
        if (updateFlag > 0) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        throw new BaseBusinessException(CommonEnum.PERMSSION_NAME.getCode(), CommonEnum.PERMSSION_NAME.getMessage());
    }
}

