/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.user;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.SmsCodeTypeEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminMember;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.UserUpdatePhoneCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserUpdatePhoneCmdExe {
    @Autowired
    CommonService commonService;
    @Autowired
    AdminUserGateway adminUserGateway;
    @Autowired
    AdminMemberGateway adminMemberGateway;
    @Autowired
    RedisDao redisDao;

    public void execute(UserUpdatePhoneCmd cmd) {
        User user = this.commonService.getCurrentUser();
        Integer type = cmd.getType();
        String newPhone = cmd.getNewPhone();
        String naCode = cmd.getNaCode();
        boolean b = this.redisDao.hasKey(cmd.getCode());
        if (!b) {
            throw new BaseBusinessException(CommonEnum.CODE_DONT.getCode(), CommonEnum.CODE_DONT.getMessage());
        }
        Long count = this.adminUserGateway.selectCountByWrapper((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AdminUser::getPhone, (Object)newPhone)).eq(AdminUser::getNaCode, (Object)naCode));
        if (count > 0L) {
            throw new BaseBusinessException(CommonEnum.PHONE_REPEAT.getCode(), CommonEnum.PHONE_REPEAT.getMessage());
        }
        if (type == 1) {
            String verificationCode = cmd.getVerificationCode();
            if (StringUtils.isBlank((String)newPhone)) {
                throw new BaseBusinessException(CommonEnum.PHONE_IS_NULL.getCode(), CommonEnum.PHONE_IS_NULL.getMessage());
            }
            if (!Pattern.compile("^1([34578])\\d{9}$").matcher(newPhone).find()) {
                throw new BaseBusinessException(CommonEnum.PHONE_FORMAT_ERROR.getCode(), CommonEnum.PHONE_FORMAT_ERROR.getMessage());
            }
            if (StringUtils.isBlank((String)cmd.getNaCode())) {
                throw new BaseBusinessException(CommonEnum.NA_CODE_IS_NULL.getCode(), CommonEnum.NA_CODE_IS_NULL.getMessage());
            }
            this.commonService.checkPhoneCode(cmd.getNaCode() + newPhone, SmsCodeTypeEnum.UPDATE_PASSWORD_BY_PHONE.getCodeType(), verificationCode);
        }
        this.updatePhoneByPhone(cmd.getNaCode(), cmd.getPhone(), newPhone, user.getId());
    }

    private void updatePhoneByPhone(String naCode, String phone, String newPhone, Long id) {
        this.adminUserGateway.updateUserInfo((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(AdminUser::getPhone, (Object)newPhone)).set(AdminUser::getNaCode, (Object)naCode)).eq(BaseEntity::getId, (Object)id));
        this.adminMemberGateway.updatetByLambdaWrapp((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(AdminMember::getPhone, (Object)newPhone)).eq(AdminMember::getUserId, (Object)id));
    }
}

