/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.user;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.SmsCodeTypeEnum;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.UserUpdatePhoneCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserUpdatePhoneCheckCmdExe {
    @Autowired
    CommonService commonService;
    @Autowired
    RedisDao redisDao;
    @Autowired
    AdminUserGateway adminUserGateway;

    public ReturnVO execute(UserUpdatePhoneCmd cmd) {
        Integer type = cmd.getType();
        String code = null;
        switch (type) {
            case 1: {
                code = this.phoneHandle(cmd);
                break;
            }
            case 2: {
                code = this.mailBoxHandle(cmd);
                break;
            }
            case 3: {
                code = this.passwordHandle(cmd);
                break;
            }
            default: {
                throw new BaseBusinessException(CommonEnum.PHONE_TYPE_EXIT.getCode(), CommonEnum.PHONE_TYPE_EXIT.getMessage());
            }
        }
        return new ReturnVO((Object)code);
    }

    private String phoneHandle(UserUpdatePhoneCmd cmd) {
        String phone = cmd.getPhone();
        String naCode = cmd.getNaCode();
        String verificationCode = cmd.getVerificationCode();
        if (StringUtils.isBlank((String)phone)) {
            throw new BaseBusinessException(CommonEnum.PHONE_IS_NULL.getCode(), CommonEnum.PHONE_IS_NULL.getMessage());
        }
        if (!Pattern.compile("^1([34578])\\d{9}$").matcher(phone).find()) {
            throw new BaseBusinessException(CommonEnum.PHONE_FORMAT_ERROR.getCode(), CommonEnum.PHONE_FORMAT_ERROR.getMessage());
        }
        if (StringUtils.isBlank((String)naCode)) {
            throw new BaseBusinessException(CommonEnum.NA_CODE_IS_NULL.getCode(), CommonEnum.NA_CODE_IS_NULL.getMessage());
        }
        this.commonService.checkPhoneCode(cmd.getNaCode() + phone, SmsCodeTypeEnum.UPDATE_PASSWORD_BY_PHONE.getCodeType(), verificationCode);
        String uuid = UUID.randomUUID().toString().replace("-", "");
        this.redisDao.put(uuid, (Object)uuid, 18000L);
        return uuid;
    }

    private String mailBoxHandle(UserUpdatePhoneCmd cmd) {
        User user = this.commonService.getCurrentUser();
        Long id = user.getId();
        AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)id));
        String verificationCode = cmd.getVerificationCode();
        this.commonService.checkEmailCode(adminUser.getMailBox(), SmsCodeTypeEnum.UPDATE_PASSWORD_BY_MAIL_BOX.getCodeType(), verificationCode);
        String uuid = UUID.randomUUID().toString().replace("-", "");
        this.redisDao.put(uuid, (Object)uuid, 18000L);
        return uuid;
    }

    private String passwordHandle(UserUpdatePhoneCmd cmd) {
        User user = this.commonService.getCurrentUser();
        AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)user.getId()));
        if (!cmd.getPassword().equals(adminUser.getPassword())) {
            throw new BaseBusinessException(CommonEnum.OLD_PASSWORD_IS_ERROR.getCode(), CommonEnum.OLD_PASSWORD_IS_ERROR.getMessage());
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        this.redisDao.put(uuid, (Object)uuid, 18000L);
        return uuid;
    }
}

