/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.user;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.SmsCodeTypeEnum;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.UserUpdatePhoneCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.admin.utils.CodeUtils;
import com.cicv.foton.admin.utils.SendEmailExample;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserSendCodeForUpdatePhoneCmdExe {
    @Autowired
    CommonService commonService;
    @Autowired
    RedisDao redisDao;
    @Value(value="${appservice.email.jsemail}")
    private String jsemail;
    @Value(value="${appservice.email.addressorEmail}")
    private String addressorEmail;
    @Value(value="${appservice.email.authorizationCode}")
    private String authorizationCode;
    @Value(value="${filtertime:0}")
    private String filtertime;

    public void execute(UserUpdatePhoneCmd cmd) {
        User user = this.commonService.getCurrentUser();
        AdminUser adminUser = this.commonService.getAdminUser((LambdaQueryWrapper<AdminUser>)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)user.getId())));
        String mailBox = adminUser.getMailBox();
        String emailCode = CodeUtils.generateCode();
        SendEmailExample.sendEmailCode((String)mailBox, (String)emailCode);
        String emailKey = this.commonService.getEmailCodeKey(SmsCodeTypeEnum.UPDATE_PASSWORD_BY_MAIL_BOX.getCodeType(), mailBox);
        this.redisDao.put(emailKey, (Object)emailCode, 1800L);
    }
}

