/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.user;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.SmsCodeTypeEnum;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.ReserPasswprdCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserResetPasswordVerifyCodeCmdExe {
    @Autowired
    CommonService commonService;
    @Autowired
    RedisDao redisDao;

    public String execute(ReserPasswprdCmd cmd) {
        String phone = cmd.getPhone();
        String naCode = cmd.getNaCode();
        if (StringUtils.isBlank((String)phone)) {
            throw new BaseBusinessException(CommonEnum.PHONE_IS_NULL.getCode(), CommonEnum.PHONE_IS_NULL.getMessage());
        }
        if (!Pattern.compile("^1([34578])\\d{9}$").matcher(phone).find()) {
            throw new BaseBusinessException(CommonEnum.PHONE_FORMAT_ERROR.getCode(), CommonEnum.PHONE_FORMAT_ERROR.getMessage());
        }
        if (StringUtils.isBlank((String)naCode)) {
            throw new BaseBusinessException(CommonEnum.NA_CODE_IS_NULL.getCode(), CommonEnum.NA_CODE_IS_NULL.getMessage());
        }
        this.commonService.getAdminUser((LambdaQueryWrapper<AdminUser>)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminUser::getPhone, (Object)phone)).eq(AdminUser::getNaCode, (Object)naCode)));
        this.commonService.checkPhoneCode(naCode + phone, SmsCodeTypeEnum.RESET_PASSWORD_TYPE.getCodeType(), cmd.getInputCode());
        String ticket = UUID.randomUUID().toString().replace("-", "");
        this.redisDao.put("foton:reset:password:" + naCode + phone + ":" + ticket, (Object)ticket, 36000L);
        return ticket;
    }
}

