/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.user;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.UserPasswordCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.google.common.base.Objects;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserResetPasswordCmdExe {
    @Autowired
    AdminUserGateway adminUserGateway;
    @Resource
    private CommonService commonService;
    @Autowired
    RedisDao redisDao;

    public void execute(UserPasswordCmd cmd) {
        String phone = cmd.getPhone();
        String password = cmd.getPassword();
        String ticket = cmd.getTicket();
        String naCode = cmd.getNaCode();
        AdminUser adminUser = this.commonService.getAdminUser((LambdaQueryWrapper<AdminUser>)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminUser::getPhone, (Object)phone)).eq(AdminUser::getNaCode, (Object)naCode)));
        if (Objects.equal((Object)adminUser.getPassword(), (Object)password)) {
            throw new BaseBusinessException(CommonEnum.PASSWORD_THE_SAME.getCode(), CommonEnum.PASSWORD_THE_SAME.getMessage());
        }
        if (StringUtils.isBlank((String)naCode)) {
            throw new BaseBusinessException(CommonEnum.NA_CODE_IS_NULL.getCode(), CommonEnum.NA_CODE_IS_NULL.getMessage());
        }
        if (StringUtils.isBlank((String)ticket)) {
            throw new BaseBusinessException(CommonEnum.PASSWORD_TICKET_IS_NULL.getCode(), CommonEnum.PASSWORD_TICKET_IS_NULL.getMessage());
        }
        String key = "foton:reset:password:" + naCode + phone + ":" + cmd.getTicket();
        if (!this.redisDao.hasKey(key)) {
            throw new BaseBusinessException(CommonEnum.PASSWORD_TICKET_IS_INVALID.getCode(), CommonEnum.PASSWORD_TICKET_IS_INVALID.getMessage());
        }
        this.adminUserGateway.updateUserInfo((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(AdminUser::getPassword, (Object)password)).set(AdminUser::getLastLoginTime, (Object)new Date())).eq(BaseEntity::getId, (Object)adminUser.getId()));
        this.redisDao.del(new String[]{key});
    }
}

