/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.user;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.SmsCodeTypeEnum;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.gateway.TenantGateway;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.UserRegistCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRegistCmdExe {
    @Autowired
    CommonService commonService;
    @Autowired
    AdminUserGateway adminUserGateway;
    @Autowired
    TenantGateway tenantGateway;
    @Autowired
    RedisDao redisDao;

    public void execute(UserRegistCmd cmd) {
        String phone = cmd.getPhone();
        String password = cmd.getPassword();
        String naCode = cmd.getNaCode();
        if (StringUtils.isBlank((String)phone)) {
            throw new BaseBusinessException(CommonEnum.PHONE_IS_NULL.getCode(), CommonEnum.PHONE_IS_NULL.getMessage());
        }
        if (!Pattern.compile("^1([34578])\\d{9}$").matcher(phone).find()) {
            throw new BaseBusinessException(CommonEnum.PHONE_FORMAT_ERROR.getCode(), CommonEnum.PHONE_FORMAT_ERROR.getMessage());
        }
        if (StringUtils.isBlank((String)naCode)) {
            throw new BaseBusinessException(CommonEnum.NA_CODE_IS_NULL.getCode(), CommonEnum.NA_CODE_IS_NULL.getMessage());
        }
        AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminUser::getPhone, (Object)phone)).eq(AdminUser::getNaCode, (Object)naCode));
        if (!Objects.isNull(adminUser)) {
            throw new BaseBusinessException(CommonEnum.PHONE_IS_USED.getCode(), String.format(CommonEnum.PHONE_IS_USED.getMessage(), phone));
        }
        if (StringUtils.isBlank((String)password)) {
            throw new BaseBusinessException(CommonEnum.PASSWORD_IS_NULL.getCode(), CommonEnum.PASSWORD_IS_NULL.getMessage());
        }
        this.commonService.checkPhoneCode(naCode + phone, SmsCodeTypeEnum.USER_REGIS_TYPE.getCodeType(), cmd.getInputCode());
        this.commonService.saveUserInfo(naCode, phone, password);
    }
}

