/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.user;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cicv.foton.admin.domain.gateway.RoleGateway;
import com.cicv.foton.admin.domain.gateway.UserGateway;
import com.cicv.foton.admin.domain.system.Role;
import com.cicv.foton.admin.dto.UserCmd;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserPageCmdExe {
    private static final Logger log = LoggerFactory.getLogger(UserPageCmdExe.class);
    @Autowired
    private RoleGateway roleGateway;
    @Autowired
    private UserGateway userGateway;

    public IPage<UserCmd> execute(UserCmd userVO) {
        Long count;
        if (Objects.isNull(userVO.getOrgId()) || userVO.getOrgId() == 0L) {
            userVO.setOrgId(null);
        }
        if ((count = this.userGateway.selectUserCnt((Object)userVO)) == null) {
            count = 0L;
        }
        userVO.setStartrow((userVO.getCurrent() - 1L) * userVO.getSize());
        List userList = this.userGateway.selectUserCmdList((Object)userVO);
        List list = this.roleGateway.selectList();
        HashMap<Long, String> roleName = new HashMap<Long, String>();
        for (Role role : list) {
            roleName.put(role.getId(), role.getName());
        }
        for (UserCmd vo : userList) {
            StringBuilder names = new StringBuilder();
            if (!StringUtils.isNotBlank((String)vo.getRoles())) continue;
            for (String s : vo.getRoles().split(",")) {
                String val = (String)roleName.get(Long.valueOf(s));
                if (Objects.isNull(val)) continue;
                names.append(",").append(val);
            }
            String name = names.toString();
            vo.setRoles(StringUtils.isNotBlank((String)name) ? name.toString().substring(1) : name);
        }
        Page page = new Page();
        page.setCurrent(userVO.getCurrent());
        page.setSize(userVO.getSize());
        page.setTotal(count.longValue());
        page.setRecords(userList);
        return page;
    }
}

