/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.user;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cicv.foton.admin.domain.gateway.TenantInfoGateway;
import com.cicv.foton.admin.domain.gateway.UserGateway;
import com.cicv.foton.admin.domain.gateway.UserRoleGateway;
import com.cicv.foton.admin.domain.system.TenantInfo;
import com.cicv.foton.admin.domain.system.UserRole;
import com.cicv.foton.admin.gatewayimpl.rmdb.UserDao;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserAddCmdExe
extends ServiceImpl<UserDao, User> {
    private static final Logger log = LoggerFactory.getLogger(UserAddCmdExe.class);
    @Resource
    private UserGateway userGateway;
    @Resource
    private TenantInfoGateway tenantInfoGateway;
    @Resource
    private UserRoleGateway userRoleGateway;

    @Transactional
    public ReturnVO<Boolean> execute(User user) {
        if (user == null || StringUtils.isBlank((String)user.getUsername())) {
            return new ReturnVO(ReturnEnum.ERROR_USER_NULL);
        }
        try {
            this.userVerification(user);
        }
        catch (BaseBusinessException e) {
            e.printStackTrace();
            return new ReturnVO(e.getCode(), e.getMessage());
        }
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"username", (Object)user.getUsername());
        if (this.userGateway.selectUserCount(qw) > 0L) {
            return new ReturnVO(ReturnEnum.ERROR_POST_PARAM.getCode(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u6b64\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        if (user.getOrgId() != null && user.getOrgId() == 0L) {
            return new ReturnVO(ReturnEnum.ERROR_POST_PARAM.getCode(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        user.setPassword(user.getPassword());
        int insertFlag = this.userGateway.insert(user);
        this.insertTenant(user.getId(), user.getUsername());
        if (insertFlag < 1) {
            return new ReturnVO("400", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002");
        }
        ArrayList<UserRole> userRoleList = new ArrayList<UserRole>();
        if (user.getRoles() != null && user.getRoles().size() > 0) {
            for (String role : user.getRoles()) {
                UserRole userRole = new UserRole();
                userRole.setUserId(user.getId().longValue());
                userRole.setRoleId(Long.valueOf(role).longValue());
                userRoleList.add(userRole);
            }
            int insertBatchFlag = this.userRoleGateway.insertBatchUserRole(userRoleList);
            if (insertBatchFlag < userRoleList.size()) {
                throw new BaseBusinessException("400", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002");
            }
        }
        if (insertFlag > 0) {
            return new ReturnVO(ReturnEnum.SUCCESS.getCode(), "\u65b0\u589e\u6210\u529f");
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u65b0\u589e\u5931\u8d25");
    }

    public void insertTenant(Long userId, String userName) {
        TenantInfo tenantInfo = new TenantInfo();
        tenantInfo.setTenantName(userName);
        tenantInfo.setUserId(userId);
        this.tenantInfoGateway.insert(tenantInfo);
    }

    private Boolean userVerification(User user) {
        String regex1 = "^[-a-z0-9A-Z_\u4e00-\u9fa5]+$";
        boolean matches = Pattern.matches(regex1, user.getUsername());
        if (!matches && user.getUsername().length() < 100) {
            throw new BaseBusinessException("400", "\u7528\u6237\u53ea\u80fd\u5305\u542b\u4e2d\u6587\u3001\u82f1\u6587\u5b57\u6bcd\u5927\u5c0f\u5199\u3001\u963f\u62c9\u4f2f\u6570\u5b57\uff0c\u4e2d\u6a2a\u7ebf\u3001\u4e0b\u6a2a\u7ebf\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26!");
        }
        return true;
    }
}

