/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.tenant;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.gateway.TenantAreaGateway;
import com.cicv.foton.admin.domain.gateway.TenantFunPackageGateway;
import com.cicv.foton.admin.domain.gateway.TenantGateway;
import com.cicv.foton.admin.domain.gateway.TenantMapGateway;
import com.cicv.foton.admin.domain.gateway.TenantPackageRelGateway;
import com.cicv.foton.admin.domain.system.AdminMember;
import com.cicv.foton.admin.domain.system.AdminMessage;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.domain.system.Tenant;
import com.cicv.foton.admin.domain.system.TenantPackageLog;
import com.cicv.foton.admin.domain.system.TenantPackageRel;
import com.cicv.foton.admin.domain.system.dataobject.TenantCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantUpdateTenantCmdExe {
    @Autowired
    private TenantGateway tenantGateway;
    @Autowired
    private TenantFunPackageGateway tenantFunPackageGateway;
    @Autowired
    private TenantAreaGateway tenantAreaGateway;
    @Autowired
    private TenantMapGateway tenantMapGateway;
    @Resource
    private TenantPackageRelGateway tenantPackageRelGateway;
    @Resource
    private AdminUserGateway adminUserGateway;
    @Resource
    private CommonService commonService;
    @Resource
    private AdminMemberGateway adminMemberGateway;

    public ReturnVO<Boolean> execute(TenantCmd tenantCmd) {
        if (Objects.isNull(tenantCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)tenantCmd.getAdminMemberId()));
        if (StringUtils.isBlank((CharSequence)adminUser.getMailBox())) {
            throw new BaseBusinessException(CommonEnum.MAIL_BOX_IS_NULL.getCode(), CommonEnum.MAIL_BOX_IS_NULL.getMessage());
        }
        Tenant tenant = new Tenant();
        BeanUtils.copyProperties((Object)tenantCmd, (Object)tenant);
        QueryWrapper tenantQueryWrapperName = new QueryWrapper();
        tenantQueryWrapperName.eq((Object)"name", (Object)tenant.getName());
        QueryWrapper tenantQueryWrapperUrl = new QueryWrapper();
        tenantQueryWrapperUrl.eq((Object)"url", (Object)tenant.getUrl());
        Tenant oldTenant = this.tenantGateway.selectById(tenantCmd.getId());
        if (-1L == oldTenant.getUserId() || !oldTenant.getUserId().equals(tenantCmd.getAdminMemberId())) {
            tenant.setUserId(Long.valueOf(-1L));
        } else {
            tenant.setUserId(tenantCmd.getAdminMemberId());
            tenant.setAdminMemberId(tenantCmd.getAdminMemberId());
        }
        if (!oldTenant.getName().equals(tenant.getName()) && this.tenantGateway.selectCount(tenantQueryWrapperName) > (long)Constant.ZERO.intValue()) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT.getCode(), CommonEnum.PERMSSION_NAME_TENANT.getMessage());
        }
        if (!oldTenant.getUrl().equals(tenant.getUrl()) && this.tenantGateway.selectCount(tenantQueryWrapperUrl) > (long)Constant.ZERO.intValue()) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_URL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_URL.getMessage());
        }
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        tenant.setUpdateUser(currentUser.getUsername());
        tenant.setUpdateTime(new Date());
        this.tenantGateway.updateById(tenant);
        Long tenantId = tenant.getId();
        ArrayList<Long> packId = new ArrayList<Long>(tenantCmd.getPackageId());
        List currPackageId = this.tenantPackageRelGateway.queryCurrPackage(tenantId);
        packId.removeAll(currPackageId);
        this.tenantPackageRelGateway.deleteRelByTenantId(tenantId);
        this.doTenantPackageRel(tenantId, tenantCmd.getPackageId(), packId);
        if (!oldTenant.getUserId().equals(tenantCmd.getAdminMemberId())) {
            this.adminMemberGateway.deleteAdminMembeByTenantId(tenantId, tenantCmd.getAdminMemberId());
            AdminMember adminMember = this.doAdminMember(tenant, adminUser);
            String msg = String.format("%s\u7ba1\u7406\u5458\u9080\u8bf7\u60a8\u6210\u4e3a%s\u79df\u6237\u7ba1\u7406\u5458", currentUser.getRealName(), tenant.getName());
            this.doMessageInfo(tenantId, tenantCmd.getAdminMemberId(), msg, adminMember);
        }
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    private AdminMember doAdminMember(Tenant tenant, AdminUser adminUser) {
        AdminMember adminMember = new AdminMember();
        adminMember.setTenantId(tenant.getId());
        adminMember.setCode("mast");
        adminMember.setRealName(tenant.getName());
        adminMember.setEmail(adminUser.getMailBox());
        adminMember.setIsEnabled(Constant.IS_ENABLE);
        adminMember.setIsConfirm(Constant.IS_ENABLE);
        adminMember.setPhone(adminUser.getPhone());
        adminMember.setOrgId(Constant.MENTEN_ORG_ID);
        adminMember.setNaCode(adminUser.getNaCode());
        adminMember.setIsMaster(Constant.TENANT_IS_MASTER);
        adminMember.setUserId(adminUser.getId());
        this.adminMemberGateway.insert(adminMember);
        return adminMember;
    }

    private void doTenantPackageRel(Long tenantId, List<Long> packageId, List<Long> packLogId) {
        for (Long l : packageId) {
            TenantPackageRel rel = new TenantPackageRel();
            rel.setTenantId(tenantId);
            rel.setPkgId(l);
            this.tenantPackageRelGateway.insertTenantPackageRel(rel);
        }
        if (!packLogId.isEmpty()) {
            this.doTenantPackageLog(tenantId, packLogId);
        }
    }

    private void doTenantPackageLog(Long tenantId, List<Long> packageId) {
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        String username = currentUser.getRealName();
        Long id = currentUser.getId();
        AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)id));
        String phone = adminUser.getPhone();
        Date date = new Date();
        for (Long l : packageId) {
            TenantPackageLog rel = new TenantPackageLog();
            rel.setTenantId(tenantId);
            rel.setCreatUserPhone(phone);
            rel.setPkgId(l);
            rel.setCreateUser(username);
            rel.setCreateTime(date);
            this.tenantPackageRelGateway.insertTenantPackagelog(rel);
        }
    }

    private void doMessageInfo(Long insertTenantId, Long memberId, String msgInfo, AdminMember adminMember) {
        User user = this.commonService.getCurrentUser();
        AdminMessage msg = new AdminMessage();
        msg.setType(Constant.TENANT_SYSTEM_TYPE);
        msg.setSourceTblName("admin_tenant");
        msg.setSourceId(adminMember.getId());
        msg.setMessage(msgInfo);
        msg.setMsgStatus(Constant.ZERO);
        msg.setReadStatus(Constant.ZERO);
        msg.setTenantId(insertTenantId);
        msg.setCreateUser(user.getUsername());
        msg.setCreateTime(new Date());
        msg.setRecipientId(memberId);
        this.adminUserGateway.insertMessage(msg);
    }
}

