/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.tenant;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.IsConfimEnum;
import com.cicv.foton.admin.domain.enums.IsEnabledEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminMember;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.domain.system.dataobject.TenantCmd;
import com.cicv.foton.admin.dto.clientobject.LoginCO;
import com.cicv.foton.admin.dto.clientobject.SimpleUserVO;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantSelectTenantCmdExe {
    @Autowired
    CommonService commonService;
    @Autowired
    AdminUserGateway adminUserGateway;
    @Autowired
    AdminMemberGateway adminMemberGateway;

    public LoginCO execute(TenantCmd tenantCmd) {
        LoginCO loginCO = new LoginCO();
        Long tenantId = tenantCmd.getId();
        String token = tenantCmd.getSecretKey();
        if (Objects.isNull(tenantCmd) || StringUtils.isBlank((String)token)) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        Long userId = this.commonService.getUserIdByToken(token);
        AdminUser adminUser = this.commonService.getAdminUser((LambdaQueryWrapper<AdminUser>)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)userId)));
        AdminMember adminMember = this.adminMemberGateway.getAdminMemberByWrapper((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminMember::getUserId, (Object)userId)).eq(CommonEntity::getTenantId, (Object)tenantId)).eq(AdminMember::getIsConfirm, (Object)IsConfimEnum.AGREE.getStatus()));
        if (Objects.isNull(adminMember)) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NULL.getCode(), CommonEnum.MEMBER_IS_NULL.getMessage());
        }
        if (Objects.equals(IsEnabledEnum.DISABLED.getStatus(), adminMember.getIsEnabled())) {
            throw new BaseBusinessException(CommonEnum.MEMBER_DISABLED.getCode(), CommonEnum.MEMBER_DISABLED.getMessage());
        }
        SimpleUserVO userVO = new SimpleUserVO();
        BeanUtils.copyProperties((Object)adminUser, (Object)userVO);
        userVO.setUserId(userId.longValue());
        loginCO.setTicket(adminUser.getTicket());
        loginCO.setUser(userVO);
        this.commonService.buildLoginInfo(loginCO, adminUser, adminMember.getId());
        loginCO.setTenantList(new ArrayList());
        loginCO.setUserId(userId);
        return loginCO;
    }
}

