/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.tenant;

import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.FunPackageGateway;
import com.cicv.foton.admin.domain.gateway.TenantFunPackageGateway;
import com.cicv.foton.admin.domain.gateway.TenantGateway;
import com.cicv.foton.admin.domain.system.dataobject.TeanantDO;
import com.cicv.foton.admin.domain.system.dataobject.TenantCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantPageListCmdExe {
    private static final Logger log = LoggerFactory.getLogger(TenantPageListCmdExe.class);
    @Autowired
    private TenantGateway tenantGateway;
    @Autowired
    private TenantFunPackageGateway tenantFunPackageGateway;
    @Autowired
    private FunPackageGateway funPackageGateway;
    @Autowired
    private CommonService commonService;

    public IPage<TeanantDO> execute(TenantCmd tenantCmd) {
        if (ObjUtil.isEmpty((Object)tenantCmd)) {
            throw new BaseBusinessException(CommonEnum.PHONE_IS_USED.getCode(), String.format(CommonEnum.PHONE_IS_USED.getMessage(), tenantCmd));
        }
        log.info("\u5165\u53c2:{}", (Object)tenantCmd.toString());
        User currentUser = this.commonService.getCurrentUser();
        Long tenantId = currentUser.getTenantId();
        if (null == tenantId) {
            return new Page();
        }
        long current = tenantCmd.getCurrent();
        long size = tenantCmd.getSize();
        if (Constant.TEW.equals(tenantCmd.getIsEnabled())) {
            tenantCmd.setIsEnabled(null);
        }
        Page page = new Page(current, Objects.equals(Constant.LONG_ZORE, size) ? Constant.DEFAULT_SIZE : size);
        IPage tenantPage = this.tenantGateway.queryTenantList(page, tenantCmd, tenantId);
        log.info("\u79df\u6237\u5217\u8868\u8fd4\u56de\u7ed3\u679c:{}" + tenantPage.getRecords().toString());
        List records = tenantPage.getRecords();
        for (TeanantDO record : records) {
            Integer count = this.tenantGateway.queryUserSize(record.getId());
            record.setCurrentCount(count);
        }
        return tenantPage;
    }
}

