/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.tenant;

import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.FunPackageGateway;
import com.cicv.foton.admin.domain.gateway.TenantGateway;
import com.cicv.foton.admin.domain.system.Tenant;
import com.cicv.foton.admin.domain.system.dataobject.PackageLogDO;
import com.cicv.foton.admin.domain.system.dataobject.TenantCmd;
import com.cicv.foton.admin.domain.system.dataobject.TenantInfoCo;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TenantGetTenantByIdCmdExe {
    @Autowired
    private TenantGateway tenantGateway;
    @Resource
    private FunPackageGateway funPackageGateway;
    @Value(value="${uploadservice.fileserver}")
    private String fileImage;

    public ReturnVO<TenantInfoCo> execute(TenantCmd tenantCmd) {
        Long id = tenantCmd.getId();
        if (Objects.isNull(id)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        Tenant tenant = this.tenantGateway.selectById(id);
        TenantInfoCo tenantCo = new TenantInfoCo();
        List packageLogDOS = this.funPackageGateway.queryFunpackgeInfoTeanantId(tenantCmd);
        if (!packageLogDOS.isEmpty()) {
            for (PackageLogDO packageLogDO : packageLogDOS) {
                String ver = packageLogDO.getVer() == null ? "" : packageLogDO.getVer();
                packageLogDO.setPackageName(packageLogDO.getPackageName() + "(" + ver + ")");
            }
        }
        BeanUtils.copyProperties((Object)tenant, (Object)tenantCo);
        String coverUrl = tenantCo.getCoverUrl();
        tenantCo.setCoverUrl(this.fileImage + coverUrl);
        tenantCo.setAdminMemberId(String.valueOf(tenant.getAdminMemberId()));
        List list = this.funPackageGateway.selectFunPackage(id);
        tenantCo.setPackageList(list);
        tenantCo.setList(packageLogDOS);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)tenantCo);
    }
}

