/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.tenant;

import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.TenantGateway;
import com.cicv.foton.admin.domain.gateway.TenantPackageRelGateway;
import com.cicv.foton.admin.domain.system.dataobject.TenantCmd;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantDeleteTenantCmdExe {
    @Autowired
    private TenantGateway tenantGateway;
    @Resource
    private TenantPackageRelGateway tenantPackageRelGateway;
    @Resource
    private AdminMemberGateway adminMemberGateway;

    public ReturnVO<Boolean> execute(TenantCmd tenantCmd) {
        Long id = tenantCmd.getId();
        if (Objects.isNull(id)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        boolean flag = this.tenantPackageRelGateway.deleteByTenantId(id);
        if (!flag) {
            return new ReturnVO(ReturnEnum.FAILED);
        }
        Integer tenantDeleteFlag = this.tenantGateway.deleteById(id);
        this.adminMemberGateway.deleteAdminMembeByTenantId(id);
        if (tenantDeleteFlag < Constant.ZERO) {
            return new ReturnVO(ReturnEnum.FAILED);
        }
        return new ReturnVO(ReturnEnum.SUCCESS);
    }
}

