/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.tenant;

import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.gateway.TenantGateway;
import com.cicv.foton.admin.domain.gateway.TenantPackageRelGateway;
import com.cicv.foton.admin.domain.system.AdminMember;
import com.cicv.foton.admin.domain.system.AdminMessage;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.domain.system.Tenant;
import com.cicv.foton.admin.domain.system.TenantPackageLog;
import com.cicv.foton.admin.domain.system.TenantPackageRel;
import com.cicv.foton.admin.domain.system.dataobject.TenantCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantAddTenantCmdExe {
    private static final Logger log = LoggerFactory.getLogger(TenantAddTenantCmdExe.class);
    @Autowired
    private TenantGateway tenantGateway;
    @Resource
    private TenantPackageRelGateway tenantPackageRelGateway;
    @Resource
    private AdminUserGateway adminUserGateway;
    @Value(value="${uploadservice.fileserver}")
    private String fileImage;
    @Resource
    private CommonService commonService;
    @Resource
    private AdminMemberGateway adminMemberGateway;

    @Transactional(rollbackFor={Exception.class})
    public ReturnVO<Boolean> execute(TenantCmd tenantCmd) {
        User currentUser = this.commonService.getCurrentUser();
        Long tenantId = currentUser.getTenantId();
        if (null == tenantId) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        if (Objects.isNull(tenantCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)tenantCmd.getAdminMemberId()));
        if (StringUtils.isBlank((String)adminUser.getMailBox())) {
            throw new BaseBusinessException(CommonEnum.MAIL_BOX_IS_NULL.getCode(), CommonEnum.MAIL_BOX_IS_NULL.getMessage());
        }
        Tenant tenant = new Tenant();
        BeanUtils.copyProperties((Object)tenantCmd, (Object)tenant);
        QueryWrapper tenantQueryWrapperName = new QueryWrapper();
        tenantQueryWrapperName.eq((Object)"name", (Object)tenant.getName());
        QueryWrapper tenantQueryWrapperUrl = new QueryWrapper();
        tenantQueryWrapperUrl.eq((Object)"url", (Object)tenant.getUrl());
        if (tenantCmd.getId() == null) {
            if (this.tenantGateway.selectCount(tenantQueryWrapperName) > (long)Constant.ZERO.intValue()) {
                throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT.getCode(), CommonEnum.PERMSSION_NAME_TENANT.getMessage());
            }
            if (this.tenantGateway.selectCount(tenantQueryWrapperUrl) > (long)Constant.ZERO.intValue()) {
                throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_URL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_URL.getMessage());
            }
            log.info("file-image-path={}" + this.fileImage);
            String path = tenantCmd.getCoverUrl();
            tenant.setCreateUser(currentUser.getUsername());
            tenant.setCreateTime(new Date());
            tenant.setUpdateTime(new Date());
            tenant.setUpdateUser(currentUser.getUsername());
            tenant.setUrl(tenantCmd.getUrl());
            tenant.setTenantId(tenantId);
            tenant.setCoverUrl(path);
            tenant.setLogoUrl(path);
            tenant.setIsEnabled(Constant.IS_ENABLED);
            tenant.setUserId(Long.valueOf(-1L));
            Long insertTenantId = this.tenantGateway.insertTenant(tenant);
            if (!Objects.isNull(insertTenantId)) {
                this.doTenantPackageRel(insertTenantId, tenantCmd.getPackageId());
                Long adminMemberId = tenant.getAdminMemberId();
                AdminMember adminMember = this.doAdminMember(tenant, adminUser);
                String msg = String.format("%s\u7ba1\u7406\u5458\u9080\u8bf7\u60a8\u6210\u4e3a%s\u79df\u6237\u7ba1\u7406\u5458", currentUser.getRealName(), tenant.getName());
                this.doMessageInfo(insertTenantId, adminMemberId, msg, adminMember.getId());
                return new ReturnVO(ReturnEnum.SUCCESS);
            }
        }
        return new ReturnVO(ReturnEnum.FAILED);
    }

    private void doTenantPackageRel(Long tenantId, List<Long> packageId) {
        if (ObjUtil.isEmpty(packageId)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        for (Long l : packageId) {
            TenantPackageRel rel = new TenantPackageRel();
            rel.setTenantId(tenantId);
            rel.setPkgId(l);
            this.tenantPackageRelGateway.insertTenantPackageRel(rel);
        }
        this.doTenantPackageLog(tenantId, packageId);
    }

    private AdminMember doAdminMember(Tenant tenant, AdminUser adminUser) {
        AdminMember adminMember = new AdminMember();
        adminMember.setTenantId(tenant.getId());
        adminMember.setCode("mast");
        adminMember.setRealName(tenant.getName());
        adminMember.setEmail(adminUser.getMailBox());
        adminMember.setIsEnabled(Constant.IS_ENABLE);
        adminMember.setIsConfirm(Constant.IS_ENABLE);
        adminMember.setPhone(adminUser.getPhone());
        adminMember.setOrgId(Constant.MENTEN_ORG_ID);
        adminMember.setNaCode(adminUser.getNaCode());
        adminMember.setIsMaster(Constant.TENANT_IS_MASTER);
        adminMember.setUserId(adminUser.getId());
        this.adminMemberGateway.insert(adminMember);
        return adminMember;
    }

    private void doMessageInfo(Long insertTenantId, Long memberId, String msgInfo, Long id) {
        User user = this.commonService.getCurrentUser();
        AdminMessage msg = new AdminMessage();
        msg.setType(Constant.TENANT_SYSTEM_TYPE);
        msg.setSourceTblName("admin_tenant");
        msg.setSourceId(id);
        msg.setMessage(msgInfo);
        msg.setMsgStatus(Constant.ZERO);
        msg.setReadStatus(Constant.ZERO);
        msg.setTenantId(insertTenantId);
        msg.setCreateUser(user.getUsername());
        msg.setCreateTime(new Date());
        msg.setRecipientId(memberId);
        this.adminUserGateway.insertMessage(msg);
    }

    private void doTenantPackageLog(Long tenantId, List<Long> packageId) {
        User user = this.commonService.getCurrentUser();
        Long id = user.getId();
        AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)id));
        String phone = adminUser.getPhone();
        Date date = new Date();
        for (Long l : packageId) {
            TenantPackageLog rel = new TenantPackageLog();
            rel.setTenantId(tenantId);
            rel.setCreatUserPhone(phone);
            rel.setPkgId(l);
            rel.setCreateUser(StringUtils.isBlank((String)adminUser.getRealName()) ? "\u6e38\u5ba2-" + phone : adminUser.getRealName());
            rel.setCreateTime(date);
            this.tenantPackageRelGateway.insertTenantPackagelog(rel);
        }
    }
}

