/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.serviceinfo;

import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AppInfoGateway;
import com.cicv.foton.admin.domain.gateway.ServiceInfoGateway;
import com.cicv.foton.admin.domain.system.ServiceInfo;
import com.cicv.foton.admin.dto.ServiceInfoCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceInfoUpdateStateByIdCmdExe {
    @Resource
    private ServiceInfoGateway serviceInfoGateway;
    @Resource
    private AppInfoGateway appInfoGateway;
    @Resource
    private CommonService commonService;

    @Transactional(rollbackFor={Exception.class})
    public ReturnVO<List<String>> execute(ServiceInfoCmd permCmd) {
        if (Objects.isNull(permCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        Long id = permCmd.getId();
        ServiceInfo oldServiceInfo = this.serviceInfoGateway.queryServiceInfoById((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id));
        User user = this.commonService.getCurrentUser();
        ServiceInfo serviceInfo = new ServiceInfo();
        if (ObjUtil.isNotNull((Object)oldServiceInfo)) {
            BeanUtils.copyProperties((Object)oldServiceInfo, (Object)serviceInfo);
        }
        BeanUtils.copyProperties((Object)permCmd, (Object)serviceInfo);
        if (!Objects.isNull(permCmd.getSrvStatus())) {
            serviceInfo.setSrvStatus(permCmd.getSrvStatus());
        }
        List list = this.appInfoGateway.quseryAppInfoBySrvId(permCmd.getId());
        ArrayList appInfoList = new ArrayList();
        if (!Objects.isNull(permCmd.getIsDeleted()) && permCmd.getIsDeleted() != Constant.IS_DELETE.intValue()) {
            if (list.isEmpty()) {
                serviceInfo.setDeleted(Constant.DELETE);
                boolean b = this.serviceInfoGateway.deleteById(permCmd.getId());
                if (b) {
                    return new ReturnVO(ReturnEnum.SUCCESS);
                }
            }
            list.stream().forEach(appInfo -> appInfoList.add(appInfo.getName()));
            return new ReturnVO(ReturnEnum.SUCCESS, appInfoList);
        }
        serviceInfo.setUpdateUser(user.getUsername());
        serviceInfo.setUpdateTime(new Date());
        boolean flag = this.serviceInfoGateway.updateServiceInfoById(serviceInfo);
        if (flag) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED);
    }
}

