/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.serviceinfo;

import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.ServiceConfigGateway;
import com.cicv.foton.admin.domain.gateway.ServiceInfoConfigRelGateway;
import com.cicv.foton.admin.domain.gateway.ServiceInfoGateway;
import com.cicv.foton.admin.domain.system.ServiceConfig;
import com.cicv.foton.admin.domain.system.ServiceInfo;
import com.cicv.foton.admin.domain.system.ServiceInfoConfigRel;
import com.cicv.foton.admin.dto.ServiceInfoCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ServiceInfoUpdateByIdCmdExe {
    @Resource
    private ServiceInfoGateway serviceInfoGateway;
    @Resource
    private ServiceInfoConfigRelGateway serviceInfoConfigRelGateway;
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Resource
    private ServiceConfigGateway serviceConfigGateway;
    @Resource
    private CommonService commonService;

    @Transactional(rollbackFor={Exception.class})
    public ReturnVO<Boolean> execute(ServiceInfoCmd permCmd) {
        if (Objects.isNull(permCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        ServiceInfo serviceInfo = new ServiceInfo();
        Long id = permCmd.getId();
        ServiceInfo oldServiceInfo = this.serviceInfoGateway.queryServiceInfoById((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id));
        if (ObjUtil.isNotNull((Object)oldServiceInfo)) {
            BeanUtils.copyProperties((Object)oldServiceInfo, (Object)serviceInfo);
        }
        BeanUtils.copyProperties((Object)permCmd, (Object)serviceInfo);
        User user = this.commonService.getCurrentUser();
        serviceInfo.setUpdateUser(user.getUsername());
        serviceInfo.setUpdateTime(new Date());
        ArrayList<Long> list = new ArrayList<Long>();
        Long familyId = permCmd.getFamilyId();
        Long coloId = permCmd.getColeId();
        list.add(familyId);
        list.add(coloId);
        boolean b = this.serviceInfoGateway.updateServiceInfoById(serviceInfo);
        if (b) {
            if (ObjUtil.isNotNull(list)) {
                this.doServiceInfoConfigRelAdd(list, serviceInfo.getId());
            }
            this.doRedisServiceConfig(list);
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED);
    }

    void doServiceInfoConfigRelAdd(List<Long> list, Long srvId) {
        User currentUser = this.commonService.getCurrentUser();
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"srv_id", (Object)srvId);
        this.serviceInfoConfigRelGateway.delete(qw);
        list.stream().forEach(config -> {
            if (!ObjectUtils.isEmpty((Object)config)) {
                ServiceInfoConfigRel rel = new ServiceInfoConfigRel();
                rel.setSrvId(srvId);
                rel.setCfgId(config);
                rel.setTenantId(currentUser.getTenantId());
                this.serviceInfoConfigRelGateway.insertServiceInfoConfigRel(rel);
            }
        });
    }

    void doRedisServiceConfig(List<Long> list) {
        String dpRedisServiceConfig = "foton:application:config";
        String applicationName = SdkContext.getApplicationName();
        ArrayList configList = new ArrayList();
        list.stream().forEach(li -> {
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"id", li);
            com.cicv.foton.common.sdk.domain.vo.ServiceConfig config = new com.cicv.foton.common.sdk.domain.vo.ServiceConfig();
            ServiceConfig serviceConfigs = this.serviceConfigGateway.queryServiceConfigByUid(qw);
            String cfgType = serviceConfigs.getCfgType();
            config.setType(cfgType);
            QueryWrapper qwType = new QueryWrapper();
            qwType.eq((Object)"value", (Object)cfgType);
            ServiceConfig type = this.serviceConfigGateway.queryServiceConfigByUid(qwType);
            config.setTypeName(type.getLabel());
            config.setConfigLabel(serviceConfigs.getLabel());
            config.setConfigValue(serviceConfigs.getValue());
            config.setUid(serviceConfigs.getUid());
            configList.add(config);
        });
        if (ObjUtil.isNotNull(configList)) {
            this.dpRedisTemplate.opsForHash().put((Object)dpRedisServiceConfig, (Object)applicationName, configList);
        }
    }
}

