/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.serviceinfo;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.ServiceInfoGateway;
import com.cicv.foton.admin.domain.system.ServiceInfo;
import com.cicv.foton.admin.dto.ServiceInfoCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ServiceInfoQueryListCmdExe {
    @Resource
    private ServiceInfoGateway serviceInfoGateway;
    @Resource
    private CommonService commonService;

    public IPage<ServiceInfo> execute(ServiceInfoCmd permCmd) {
        if (Objects.isNull(permCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        QueryWrapper tenantQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)permCmd.getName())) {
            tenantQueryWrapper.like((Object)"chn_name", (Object)permCmd.getName());
        }
        if (!Objects.isNull(permCmd.getSrvStatus()) && permCmd.getSrvStatus() < Constant.SRV_STATUS) {
            tenantQueryWrapper.eq((Object)"srv_status", (Object)permCmd.getSrvStatus());
        }
        tenantQueryWrapper.eq((Object)"is_deleted", (Object)Constant.IS_DELETE);
        tenantQueryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        tenantQueryWrapper.orderByAsc((Object)"srv_status");
        tenantQueryWrapper.orderByDesc((Object)"create_time");
        long current = permCmd.getCurrent();
        long size = permCmd.getSize();
        Page tenantPage = new Page(current, Objects.equals(Constant.LONG_ZORE, size) ? Constant.DEFAULT_SIZE : size);
        return this.serviceInfoGateway.queryServiceInfoPage(tenantPage, tenantQueryWrapper);
    }
}

