/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.serviceinfo;

import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.ServiceInfoGateway;
import com.cicv.foton.admin.domain.system.ServiceInfo;
import com.cicv.foton.admin.dto.AppInfoCmd;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ServiceInfoConfigurationListCmdExe {
    @Resource
    private ServiceInfoGateway serviceInfoGateway;

    public ReturnVO<List<ServiceInfo>> execute(AppInfoCmd appInfoCmd) {
        if (ObjUtil.isNull((Object)appInfoCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        if (appInfoCmd.getConfigId().size() != 0) {
            return new ReturnVO(ReturnEnum.SUCCESS, this.doServiceInfo(appInfoCmd));
        }
        List serviceInfos = this.serviceInfoGateway.queryServiceInfoList(appInfoCmd.getName());
        if (Objects.isNull(serviceInfos)) {
            return new ReturnVO(ReturnEnum.ERROR_NOT_FOUND, new ArrayList());
        }
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)serviceInfos);
    }

    private List<ServiceInfo> doServiceInfo(AppInfoCmd appInfoCmd) {
        ArrayList<ServiceInfo> list = new ArrayList<ServiceInfo>();
        List configId = appInfoCmd.getConfigId();
        configId.stream().forEach(config -> {
            ServiceInfo info = this.serviceInfoGateway.queryServiceInfoConfig((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)Long.valueOf(config)));
            list.add(info);
        });
        return list;
    }
}

