/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.serviceinfo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.ServiceConfigGateway;
import com.cicv.foton.admin.domain.gateway.ServiceInfoConfigRelGateway;
import com.cicv.foton.admin.domain.gateway.ServiceInfoGateway;
import com.cicv.foton.admin.domain.gateway.ServiceModelDataGroupGateway;
import com.cicv.foton.admin.domain.gateway.ServiceModelEnumGateway;
import com.cicv.foton.admin.domain.gateway.ServiceModelGateway;
import com.cicv.foton.admin.domain.gateway.ServiceModelMetaDateGateway;
import com.cicv.foton.admin.domain.gateway.ServiceResourceGateway;
import com.cicv.foton.admin.domain.system.ServiceConfig;
import com.cicv.foton.admin.domain.system.ServiceInfo;
import com.cicv.foton.admin.domain.system.ServiceModel;
import com.cicv.foton.admin.domain.system.ServiceModelDataGroup;
import com.cicv.foton.admin.domain.system.ServiceModelEnum;
import com.cicv.foton.admin.domain.system.ServiceModelMetaDate;
import com.cicv.foton.admin.domain.system.ServiceResource;
import com.cicv.foton.admin.dto.ServiceInfoCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.domain.vo.AppInfo;
import com.cicv.foton.common.sdk.domain.vo.ApplicationInfo;
import com.cicv.foton.common.sdk.domain.vo.Config;
import com.cicv.foton.common.sdk.domain.vo.ConfigItems;
import com.cicv.foton.common.sdk.domain.vo.Content;
import com.cicv.foton.common.sdk.domain.vo.DataEnumItems;
import com.cicv.foton.common.sdk.domain.vo.DataGroup;
import com.cicv.foton.common.sdk.domain.vo.DataModelItems;
import com.cicv.foton.common.sdk.domain.vo.DimField;
import com.cicv.foton.common.sdk.domain.vo.FunctionItems;
import com.cicv.foton.common.sdk.domain.vo.IndFieldList;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceInfoAddCmdExe {
    private static final Logger log = LoggerFactory.getLogger(ServiceInfoAddCmdExe.class);
    @Resource
    private ServiceInfoGateway serviceInfoGateway;
    @Resource
    private ServiceResourceGateway serviceResourceGateway;
    @Resource
    private ServiceModelEnumGateway serviceModelEnumGateway;
    @Resource
    private ServiceModelGateway serviceModelGateway;
    @Resource
    private ServiceModelDataGroupGateway serviceModelDataGroupGateway;
    @Resource
    private ServiceConfigGateway serviceConfigGateway;
    @Resource
    private ServiceModelMetaDateGateway serviceModelMetaDateGateway;
    @Resource
    private ServiceInfoConfigRelGateway serviceInfoConfigRelGateway;
    @Resource
    private CommonService commonService;

    @Transactional(rollbackFor={Exception.class})
    public ReturnVO<ServiceInfo> execute(ServiceInfoCmd permCmd) {
        if (Objects.isNull(permCmd) && Objects.isNull(permCmd.getUrl())) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        boolean flag = false;
        String url = permCmd.getUrl();
        String pathUrl = url + "/api/v1/app/basicinfo";
        ApplicationInfo applicationInfo = null;
        if (!ObjUtil.isNull((Object)url)) {
            applicationInfo = this.doHttpUrlServiceCall(pathUrl);
        }
        if (ObjUtil.isNull(applicationInfo) || ObjUtil.isNull((Object)applicationInfo.getAppInfo()) || ObjUtil.isNull((Object)applicationInfo.getAppInfo().getName())) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_URL_SERVICE_CALL.getCode(), CommonEnum.PERMSSION_URL_SERVICE_CALL.getMessage());
        }
        AppInfo appInfo = applicationInfo.getAppInfo();
        List functionItems = applicationInfo.getFunctionItems();
        List dataEnumItems = applicationInfo.getDataEnumItems();
        List dataModelItems = applicationInfo.getDataModelItems();
        List configItems = applicationInfo.getConfigItems();
        ServiceInfo serviceInfo = this.doServiceInfo(appInfo, pathUrl);
        Long serviceInfoId = serviceInfo.getId();
        if (!ObjUtil.isNull((Object)serviceInfoId)) {
            if (ObjUtil.isNotNull((Object)functionItems)) {
                this.doFunctionItems(functionItems, serviceInfoId, Constant.ZEROL);
            }
            if (ObjUtil.isNotNull((Object)dataEnumItems)) {
                this.doDataEnumItems(dataEnumItems, serviceInfoId);
            }
            if (ObjUtil.isNotNull((Object)dataModelItems)) {
                this.doDataModelItems(dataModelItems, serviceInfoId);
            }
            if (ObjUtil.isNotNull((Object)configItems)) {
                this.doConfigItems(configItems, serviceInfoId, Constant.ZEROL);
            }
        }
        return new ReturnVO((Object)serviceInfo);
    }

    public ServiceInfo doServiceInfo(AppInfo appInfo, String url) {
        if (ObjUtil.isNull((Object)appInfo) && ObjUtil.isNull((Object)url)) {
            log.info("\u670d\u52a1\u4fe1\u606f\u5224\u7a7a\u65e5\u5fd7:appInfo:${}" + appInfo.toString() + ":url:${url}" + url);
            throw new BaseBusinessException(CommonEnum.PERMSSION_URL_SERVICE_CALL.getCode(), CommonEnum.PERMSSION_URL_SERVICE_CALL.getMessage());
        }
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        Date date = new Date();
        String username = user.getUsername();
        String uid = appInfo.getUid();
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"uid", (Object)uid);
        qw.eq((Object)"is_deleted", (Object)Constant.SERVICE_ZERO);
        ServiceInfo info = this.serviceInfoGateway.queryServiceInfoById(qw);
        ServiceInfo serviceInfo = new ServiceInfo();
        if (ObjUtil.isNotNull((Object)info)) {
            BeanUtils.copyProperties((Object)info, (Object)serviceInfo);
        }
        serviceInfo.setUrl(url);
        serviceInfo.setName(appInfo.getName());
        serviceInfo.setLogo(appInfo.getLogo());
        serviceInfo.setVer(appInfo.getVersion());
        serviceInfo.setDeveloper(appInfo.getDeveloper());
        serviceInfo.setContact(String.valueOf(appInfo.getContact()));
        serviceInfo.setIntroduction(appInfo.getIntroduction());
        serviceInfo.setUpdateRecord(appInfo.getUpdateRecord().trim());
        serviceInfo.setSrvStatus(Constant.SERVICE_ZERO);
        serviceInfo.setChnName(appInfo.getChnName());
        serviceInfo.setReleaseTime(date);
        serviceInfo.setUid(uid);
        serviceInfo.setTenantId(tenantId);
        if (ObjUtil.isNull((Object)info)) {
            serviceInfo.setCreateUser(username);
            serviceInfo.setCreateTime(date);
            Long id = this.serviceInfoGateway.insertServiceInfo(serviceInfo);
            serviceInfo.setId(id);
        } else {
            serviceInfo.setCreateTime(date);
            serviceInfo.setUpdateUser(username);
            serviceInfo.setUpdateTime(date);
            this.serviceInfoGateway.updateServiceInfoById(serviceInfo);
        }
        return serviceInfo;
    }

    ApplicationInfo doHttpUrlServiceCall(String serviceUrl) {
        try {
            String results = HttpUtil.get((String)serviceUrl);
            JSONObject jsonObject = JSON.parseObject((String)results);
            Object data = jsonObject.get((Object)"data");
            log.info("data info: " + data.toString());
            return (ApplicationInfo)JSONUtil.toBean((String)data.toString(), ApplicationInfo.class);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public boolean doFunctionItems(List<FunctionItems> functionItems, Long svrId, Long parenId) {
        if (CollUtil.isEmpty(functionItems) && Objects.isNull(svrId) && Objects.isNull(parenId)) {
            return false;
        }
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        Date date = new Date();
        String username = user.getUsername();
        Long parentId = null;
        for (FunctionItems functionItem : functionItems) {
            List children;
            ServiceResource serviceResource = new ServiceResource();
            String uid = functionItem.getUid();
            LambdaQueryWrapper lqw = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServiceResource::getUid, (Object)uid);
            ServiceResource resource = this.serviceResourceGateway.queryServiceResour(lqw);
            if (ObjUtil.isNotNull((Object)resource)) {
                BeanUtils.copyProperties((Object)resource, (Object)serviceResource);
            }
            serviceResource.setSrvId(svrId);
            serviceResource.setParentId(parenId);
            serviceResource.setName(functionItem.getTitle());
            serviceResource.setAuthCode(functionItem.getPermissionCode());
            serviceResource.setPath(functionItem.getPath());
            serviceResource.setIcon(functionItem.getIcon());
            serviceResource.setMenuType(Integer.valueOf(Math.toIntExact(functionItem.getType())));
            serviceResource.setUid(uid);
            serviceResource.setTenantId(tenantId);
            if (ObjUtil.isNull((Object)resource)) {
                serviceResource.setCreateUser(username);
                serviceResource.setCreateTime(date);
                parentId = this.serviceResourceGateway.insertServiceResource(serviceResource);
            } else {
                serviceResource.setUpdateUser(username);
                serviceResource.setUpdateTime(date);
                this.serviceResourceGateway.updateServiceResource(serviceResource);
                parentId = serviceResource.getId();
            }
            if (!CollUtil.isNotEmpty((Collection)functionItem.getChildren()) || !CollUtil.isNotEmpty((Collection)(children = functionItem.getChildren()))) continue;
            this.doChildren(children, svrId, parentId);
        }
        return true;
    }

    boolean doChildren(List<FunctionItems> functionItems, Long svrId, Long parenId) {
        if (CollUtil.isEmpty(functionItems) && Objects.isNull(svrId) && Objects.isNull(parenId)) {
            return false;
        }
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        Date date = new Date();
        String username = user.getUsername();
        Long childrenParentId = null;
        for (FunctionItems functionItem : functionItems) {
            ServiceResource serviceResource = new ServiceResource();
            String uid = functionItem.getUid();
            LambdaQueryWrapper lqw = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServiceResource::getUid, (Object)uid)).eq(CommonEntity::getTenantId, (Object)tenantId);
            ServiceResource resource = this.serviceResourceGateway.queryServiceResour(lqw);
            if (ObjUtil.isNotNull((Object)resource)) {
                BeanUtils.copyProperties((Object)resource, (Object)serviceResource);
            }
            serviceResource.setSrvId(svrId);
            serviceResource.setParentId(parenId);
            serviceResource.setName(functionItem.getTitle());
            serviceResource.setAuthCode(functionItem.getPermissionCode());
            serviceResource.setPath(functionItem.getPath());
            serviceResource.setIcon(functionItem.getIcon());
            serviceResource.setMenuType(Integer.valueOf(Math.toIntExact(functionItem.getType())));
            serviceResource.setUid(uid);
            serviceResource.setTenantId(tenantId);
            if (ObjUtil.isNull((Object)resource)) {
                serviceResource.setCreateUser(username);
                serviceResource.setCreateTime(date);
                childrenParentId = this.serviceResourceGateway.insertServiceResource(serviceResource);
            } else {
                serviceResource.setUpdateUser(username);
                serviceResource.setUpdateTime(date);
                this.serviceResourceGateway.updateServiceResource(serviceResource);
                childrenParentId = serviceResource.getId();
            }
            if (!CollUtil.isNotEmpty((Collection)functionItem.getContent())) continue;
            for (List contents : functionItem.getContent()) {
                this.doContent(contents, childrenParentId, svrId);
            }
        }
        return true;
    }

    public void doContent(List<Content> content, Long parentId, Long srvId) {
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        Date date = new Date();
        String username = user.getUsername();
        for (Content con : content) {
            ServiceResource serviceResource = new ServiceResource();
            String uid = con.getUid();
            LambdaQueryWrapper lqw = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServiceResource::getUid, (Object)uid);
            ServiceResource resource = this.serviceResourceGateway.queryServiceResour(lqw);
            if (ObjUtil.isNotNull((Object)resource)) {
                BeanUtils.copyProperties((Object)resource, (Object)serviceResource);
            }
            serviceResource.setSrvId(srvId);
            serviceResource.setParentId(parentId);
            serviceResource.setName(con.getTitle());
            serviceResource.setAuthCode(con.getPermissionCode());
            serviceResource.setMenuType(Integer.valueOf(Math.toIntExact(con.getType())));
            Long type = con.getType();
            if (type == 1L) {
                serviceResource.setComponent(con.getPath());
                serviceResource.setPath("view");
            } else {
                serviceResource.setPath(con.getPath());
            }
            serviceResource.setUid(uid);
            serviceResource.setTenantId(tenantId);
            if (ObjUtil.isNull((Object)resource)) {
                serviceResource.setCreateUser(username);
                serviceResource.setCreateTime(date);
                parentId = this.serviceResourceGateway.insertServiceResource(serviceResource);
            } else {
                serviceResource.setUpdateUser(username);
                serviceResource.setUpdateTime(date);
                this.serviceResourceGateway.updateServiceResource(serviceResource);
                parentId = serviceResource.getId();
            }
            if (!ObjUtil.isNotNull((Object)con.getContentChildren())) continue;
            this.doContent(con.getContentChildren(), parentId, srvId);
        }
    }

    public boolean doDataEnumItems(List<DataEnumItems> dataEnumItems, Long srvId) {
        if (CollUtil.isEmpty(dataEnumItems) && Objects.isNull(srvId)) {
            return false;
        }
        Date date = new Date();
        User user = this.commonService.getCurrentUser();
        String username = user.getUsername();
        Long tenantId = user.getTenantId();
        QueryWrapper qw = new QueryWrapper();
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        for (DataEnumItems dataEnumItem : dataEnumItems) {
            String uid = dataEnumItem.getUid();
            qw.eq((Object)"uid", (Object)uid);
            List list = this.serviceModelEnumGateway.quertyServiceModelEnumByUid(qw);
            if (!CollUtil.isNotEmpty((Collection)dataEnumItem.getEnumMap())) continue;
            Iterator iterator = dataEnumItem.getEnumMap().iterator();
            while (iterator.hasNext()) {
                Map longStringMap;
                Map map = longStringMap = (Map)iterator.next();
                ServiceModelEnum serviceModelEnum = new ServiceModelEnum();
                serviceModelEnum.setSrvId(srvId);
                serviceModelEnum.setFieldName(dataEnumItem.getName());
                serviceModelEnum.setFieldNote(dataEnumItem.getChnName());
                serviceModelEnum.setTenantId(tenantId);
                serviceModelEnum.setDeleted(Constant.ZERO);
                String key = (String)map.get("key");
                String value = (String)map.get("value");
                serviceModelEnum.setEnumKey(key);
                serviceModelEnum.setEnumValue(value);
                serviceModelEnum.setUid(uid);
                if (list.size() == 0) {
                    serviceModelEnum.setCreateUser(username);
                    serviceModelEnum.setCreateTime(date);
                    this.serviceModelEnumGateway.insertServiceModelEnum(serviceModelEnum);
                    continue;
                }
                for (ServiceModelEnum modelEnum : list) {
                    String enumValue = modelEnum.getEnumValue();
                    String enumKey = modelEnum.getEnumKey();
                    if (!enumKey.equals(key) || !enumValue.equals(value)) continue;
                    serviceModelEnum.setId(modelEnum.getId());
                    serviceModelEnum.setUpdateUser(username);
                    serviceModelEnum.setUpdateTime(date);
                    this.serviceModelEnumGateway.updateServiceModelEnum(serviceModelEnum);
                }
            }
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean doDataModelItems(List<DataModelItems> dataModelItems, Long srvId) {
        if (CollUtil.isEmpty(dataModelItems) && Objects.isNull(srvId)) {
            return false;
        }
        log.info("\u670d\u52a1\u4fe1\u606f\u5224\u7a7a\u65e5\u5fd7:appInfo:${}" + dataModelItems.toString() + ":url:${url}" + srvId);
        Long modelId = null;
        User user = this.commonService.getCurrentUser();
        String username = user.getUsername();
        Long tenantId = user.getTenantId();
        Date date = new Date();
        for (DataModelItems dataModelItem : dataModelItems) {
            List dataGroup;
            List indFieldList;
            ServiceModel serviceModel = new ServiceModel();
            String uid = dataModelItem.getUid();
            LambdaQueryWrapper lqw = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServiceModel::getUid, (Object)uid);
            ServiceModel model = this.serviceModelGateway.queryServiceModel(lqw);
            if (ObjUtil.isNotNull((Object)model)) {
                BeanUtils.copyProperties((Object)model, (Object)serviceModel);
            }
            serviceModel.setSrvId(srvId);
            serviceModel.setModelName(dataModelItem.getName());
            serviceModel.setModelNote(dataModelItem.getChnName());
            serviceModel.setDataScope(StringUtils.isNotEmpty((CharSequence)dataModelItem.getDataScope()) ? dataModelItem.getDataScope() : "shareable");
            serviceModel.setCreateUser(username);
            serviceModel.setCreateTime(date);
            serviceModel.setUid(uid);
            serviceModel.setTenantId(tenantId);
            if (ObjUtil.isNull((Object)model)) {
                serviceModel.setCreateUser(username);
                serviceModel.setCreateTime(date);
                modelId = this.serviceModelGateway.insertServiceModel(serviceModel);
            } else {
                serviceModel.setUpdateUser(username);
                serviceModel.setUpdateTime(date);
                this.serviceModelGateway.updateServiceModel(serviceModel);
                modelId = serviceModel.getId();
            }
            List dimFieldList = dataModelItem.getDimFieldList();
            if (ObjUtil.isNotNull((Object)dimFieldList)) {
                this.doDimFieldAndIndField(dimFieldList, modelId);
            }
            if (ObjUtil.isNotNull((Object)(indFieldList = dataModelItem.getIndFieldList()))) {
                this.doIndField(indFieldList, modelId);
            }
            if (!ObjUtil.isNotNull((Object)(dataGroup = dataModelItem.getDataGroup()))) continue;
            this.doDataGroup(dataGroup, modelId, Constant.ZEROL);
        }
        return true;
    }

    public void doDimFieldAndIndField(List<DimField> dimFieldList, Long modelId) {
        if (CollUtil.isEmpty(dimFieldList) && Objects.isNull(modelId)) {
            return;
        }
        User user = this.commonService.getCurrentUser();
        String username = user.getUsername();
        Long tenantId = user.getTenantId();
        Date date = new Date();
        for (DimField dimField : dimFieldList) {
            ServiceModelMetaDate modelMetaDate = new ServiceModelMetaDate();
            String uid = dimField.getUid();
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"uid", (Object)uid);
            ServiceModelMetaDate model = this.serviceModelMetaDateGateway.queryModelMetaDateByUid(qw);
            if (ObjUtil.isNotNull((Object)model)) {
                BeanUtils.copyProperties((Object)model, (Object)modelMetaDate);
            }
            String name = dimField.getName();
            String chnName = dimField.getChnName();
            String type = String.valueOf(dimField.getType());
            Long required = dimField.getRequired();
            modelMetaDate.setRequired(dimField.getRequired());
            modelMetaDate.setRowType("dim");
            modelMetaDate.setSrvModelId(modelId);
            modelMetaDate.setFieldName(name);
            modelMetaDate.setFieldNote(chnName);
            modelMetaDate.setDataType(type);
            modelMetaDate.setRequired(required);
            modelMetaDate.setUid(uid);
            modelMetaDate.setTenantId(tenantId);
            if (ObjUtil.isNull((Object)model)) {
                modelMetaDate.setCreateUser(username);
                modelMetaDate.setCreateTime(date);
                this.serviceModelMetaDateGateway.insertServiceModelMetaDate(modelMetaDate);
                continue;
            }
            modelMetaDate.setUpdateUser(username);
            modelMetaDate.setUpdateTime(date);
            this.serviceModelMetaDateGateway.updateServiceModelMetaDate(modelMetaDate);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void doIndField(List<IndFieldList> indFieldList, Long modelId) {
        if (CollUtil.isEmpty(indFieldList) && Objects.isNull(modelId)) {
            return;
        }
        User user = this.commonService.getCurrentUser();
        String username = user.getUsername();
        Long tenantId = user.getTenantId();
        Date date = new Date();
        for (IndFieldList fieldList : indFieldList) {
            String name = fieldList.getName();
            String chnName = fieldList.getChnName();
            String type = String.valueOf(fieldList.getType());
            Long required = fieldList.getRequired();
            ServiceModelMetaDate modelMetaDate = new ServiceModelMetaDate();
            String uid = fieldList.getUid();
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"uid", (Object)uid);
            ServiceModelMetaDate model = this.serviceModelMetaDateGateway.queryModelMetaDateByUid(qw);
            if (ObjUtil.isNotNull((Object)model)) {
                BeanUtils.copyProperties((Object)model, (Object)modelMetaDate);
            }
            modelMetaDate.setUid(uid);
            modelMetaDate.setRowType("ind");
            modelMetaDate.setSrvModelId(modelId);
            modelMetaDate.setFieldName(name);
            modelMetaDate.setFieldNote(chnName);
            modelMetaDate.setDataType(type);
            modelMetaDate.setRequired(required);
            modelMetaDate.setTenantId(tenantId);
            if (ObjUtil.isNull((Object)model)) {
                modelMetaDate.setCreateUser(username);
                modelMetaDate.setCreateTime(date);
                this.serviceModelMetaDateGateway.insertServiceModelMetaDate(modelMetaDate);
                continue;
            }
            modelMetaDate.setUpdateUser(username);
            modelMetaDate.setUpdateTime(date);
            this.serviceModelMetaDateGateway.updateServiceModelMetaDate(modelMetaDate);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void doDataGroup(List<DataGroup> dataGroup, Long modelId, Long id) {
        if (ObjUtil.isNotEmpty(dataGroup) && !Objects.isNull(modelId) && !Objects.isNull(id)) {
            Date date = new Date();
            User user = this.commonService.getCurrentUser();
            String username = user.getUsername();
            Long tenantId = user.getTenantId();
            for (DataGroup group : dataGroup) {
                List childrenGroup;
                Long parentId = null;
                ServiceModelDataGroup serviceModelDataGroup = new ServiceModelDataGroup();
                String uid = group.getUid();
                QueryWrapper qw = new QueryWrapper();
                qw.eq((Object)"uid", (Object)uid);
                ServiceModelDataGroup modelDataGroup = this.serviceModelDataGroupGateway.queryServiceModelDataGroup(qw);
                if (ObjUtil.isNotNull((Object)modelDataGroup)) {
                    BeanUtils.copyProperties((Object)modelDataGroup, (Object)serviceModelDataGroup);
                }
                serviceModelDataGroup.setSrvModelId(modelId);
                serviceModelDataGroup.setParentId(id);
                serviceModelDataGroup.setUid(uid);
                serviceModelDataGroup.setCode(group.getCode());
                serviceModelDataGroup.setName(group.getName());
                serviceModelDataGroup.setTenantId(tenantId);
                if (ObjUtil.isNull((Object)modelDataGroup)) {
                    serviceModelDataGroup.setCreateUser(username);
                    serviceModelDataGroup.setCreateTime(date);
                    parentId = this.serviceModelDataGroupGateway.insetServiceModelDataGroup(serviceModelDataGroup);
                } else {
                    serviceModelDataGroup.setUpdateUser(username);
                    serviceModelDataGroup.setUpdateTime(date);
                    this.serviceModelDataGroupGateway.updateServiceModelDataGroup(serviceModelDataGroup);
                    parentId = serviceModelDataGroup.getId();
                }
                if (!CollUtil.isNotEmpty((Collection)group.getChildrenGroup()) || !CollUtil.isNotEmpty((Collection)(childrenGroup = group.getChildrenGroup()))) continue;
                this.doDataGroup(childrenGroup, modelId, parentId);
            }
        }
    }

    public boolean doConfigItems(List<ConfigItems> configItems, Long srvId, Long id) {
        if (ObjUtil.isEmpty(configItems) && Objects.isNull(srvId)) {
            return false;
        }
        User user = this.commonService.getCurrentUser();
        String username = user.getUsername();
        Long tenantId = user.getTenantId();
        Date date = new Date();
        for (ConfigItems configItem : configItems) {
            Long parentId = null;
            ServiceConfig serviceConfig = new ServiceConfig();
            serviceConfig.setParentId(id);
            String uid = configItem.getUid();
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"uid", (Object)uid);
            ServiceConfig config = this.serviceConfigGateway.queryServiceConfigByUid(qw);
            if (ObjUtil.isNotNull((Object)config)) {
                BeanUtils.copyProperties((Object)config, (Object)serviceConfig);
            }
            serviceConfig.setSrvId(srvId);
            serviceConfig.setUid(uid);
            serviceConfig.setLabel(configItem.getName());
            serviceConfig.setValue(configItem.getCode());
            serviceConfig.setSortNo(Constant.SERVICE_ZERO);
            serviceConfig.setDescription(configItem.getDescription());
            serviceConfig.setDeleted(Constant.SERVICE_ZERO);
            serviceConfig.setCreateUser(username);
            serviceConfig.setTenantId(tenantId);
            serviceConfig.setCreateTime(date);
            if (ObjUtil.isNull((Object)config)) {
                serviceConfig.setCreateUser(username);
                serviceConfig.setTenantId(tenantId);
                parentId = this.serviceConfigGateway.insertServiceConfig(serviceConfig);
            } else {
                serviceConfig.setCreateUser(username);
                serviceConfig.setTenantId(tenantId);
                this.serviceConfigGateway.updateServiceConfig(serviceConfig);
                parentId = serviceConfig.getId();
            }
            String cfgType = configItem.getCode();
            if (!CollUtil.isNotEmpty((Collection)configItem.getConfig())) continue;
            Long finalParentId = parentId;
            for (Config item : configItem.getConfig()) {
                ServiceConfig sum = new ServiceConfig();
                String sumUid = item.getUid();
                QueryWrapper qwSun = new QueryWrapper();
                qwSun.eq((Object)"uid", (Object)sumUid);
                ServiceConfig sumConfig = this.serviceConfigGateway.queryServiceConfigByUid(qwSun);
                if (ObjUtil.isNotNull((Object)sumConfig)) {
                    BeanUtils.copyProperties((Object)sumConfig, (Object)sum);
                }
                sum.setSrvId(srvId);
                sum.setParentId(finalParentId);
                sum.setCfgType(cfgType);
                sum.setUid(sumUid);
                sum.setLabel(item.getName());
                sum.setValue(item.getCode());
                sum.setSortNo(Integer.valueOf(Math.toIntExact(item.getSortNo())));
                sum.setVersion(Constant.ZEROL);
                sum.setDeleted(Constant.SERVICE_ZERO);
                sum.setTenantId(tenantId);
                if (ObjUtil.isNull((Object)sumConfig)) {
                    sum.setCreateUser(username);
                    sum.setTenantId(tenantId);
                    this.serviceConfigGateway.insertServiceConfig(sum);
                    continue;
                }
                sum.setCreateUser(username);
                sum.setTenantId(tenantId);
                this.serviceConfigGateway.updateServiceConfig(sum);
                serviceConfig.getId();
            }
        }
        return true;
    }
}

