/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.role;

import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.RoleGateway;
import com.cicv.foton.admin.domain.system.Role;
import com.cicv.foton.admin.dto.RoleCmd;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RoleUpdateStateCmdExe {
    @Resource
    private RoleGateway roleGateway;

    public ReturnVO<Boolean> execute(RoleCmd role) {
        if (Objects.isNull(role)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        Role oldRole = this.roleGateway.selectRoleById(role.getId());
        if (!Objects.isNull(role.getIsEnabled()) && role.getIsEnabled() < Constant.TEW) {
            oldRole.setIsEnabled(role.getIsEnabled());
        }
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        oldRole.setUpdateUser(currentUser.getUsername());
        oldRole.setUpdateTime(new Date());
        int updateFlag = this.roleGateway.updateRoleById(oldRole);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }
}

