/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.role;

import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminRolePermRelGateway;
import com.cicv.foton.admin.domain.gateway.RoleGateway;
import com.cicv.foton.admin.domain.system.AdminRolePermRel;
import com.cicv.foton.admin.domain.system.Role;
import com.cicv.foton.admin.dto.RoleCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class RoleUpdateCmdExe {
    private static final Logger log = LoggerFactory.getLogger(RoleUpdateCmdExe.class);
    @Resource
    private RoleGateway roleGateway;
    @Resource
    private AdminRolePermRelGateway adminRolePermRelGateway;
    @Resource
    private CommonService commonService;

    public ReturnVO<Boolean> execute(RoleCmd roleCmd) {
        if (Objects.isNull(roleCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        User currentUser = this.commonService.getCurrentUser();
        Long tenantId = currentUser.getTenantId();
        if (null == tenantId) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        Role oldRole = this.roleGateway.selectRoleById(roleCmd.getId());
        if (ObjUtil.isNotNull((Object)roleCmd.getName())) {
            this.roleGateway.isRepeatName(roleCmd.getName(), tenantId, roleCmd.getId());
            oldRole.setName(roleCmd.getName());
        }
        if (ObjUtil.isNotNull((Object)roleCmd.getDescription())) {
            oldRole.setDescription(roleCmd.getDescription());
        }
        oldRole.setUpdateUser(currentUser.getUsername());
        oldRole.setUpdateTime(new Date());
        int updateFlag = this.roleGateway.updateRoleById(oldRole);
        if (updateFlag > 0) {
            this.doUpdateRole(roleCmd);
        }
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    private void doUpdateRole(RoleCmd roleCmd) {
        User currentUser = this.commonService.getCurrentUser();
        Long tenantId = currentUser.getTenantId();
        List permId = roleCmd.getPermId();
        if (null != permId && !permId.isEmpty()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(AdminRolePermRel::getRoleId, (Object)roleCmd.getId());
            this.adminRolePermRelGateway.deleteRleByRoleId(wrapper);
            for (Long id : permId) {
                AdminRolePermRel rel = new AdminRolePermRel();
                rel.setPerId(id);
                rel.setRoleId(roleCmd.getId());
                rel.setTenantId(tenantId);
                this.adminRolePermRelGateway.inserAdminRolePermRel(rel);
            }
        }
    }
}

