/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.role;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminRolePermRelGateway;
import com.cicv.foton.admin.domain.gateway.RoleGateway;
import com.cicv.foton.admin.domain.system.AdminRolePermRel;
import com.cicv.foton.admin.domain.system.Role;
import com.cicv.foton.admin.dto.RoleCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Resource;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class RoleInsetCmdExe {
    private static final Logger log = LoggerFactory.getLogger(RoleInsetCmdExe.class);
    @Resource
    private RoleGateway roleGateway;
    @Resource
    private AdminRolePermRelGateway adminRolePermRelGateway;
    @Resource
    private CommonService commonService;

    public ReturnVO<Boolean> execute(RoleCmd role) {
        boolean flag = false;
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        if (Objects.isNull(tenantId)) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        if (Objects.isNull(role.getName()) || Objects.isNull(role.getDescription())) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        LambdaQueryWrapper lwq = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Role::getName, (Object)role.getName())).eq(CommonEntity::getTenantId, (Object)tenantId)).eq(CommonEntity::getDeleted, (Object)0);
        Role roleData = this.roleGateway.selectRole(lwq);
        if (roleData != null) {
            throw new BaseBusinessException(CommonEnum.ROLE_NAME_REPEAT.getCode(), CommonEnum.ROLE_NAME_REPEAT.getMessage());
        }
        Role newRole = new Role();
        newRole.setName(role.getName());
        newRole.setDescription(role.getDescription());
        String code = this.doGenerateRoleCode(role.getName());
        newRole.setCode(code);
        newRole.setCreateTime(new Date());
        newRole.setIsEnabled(Integer.valueOf(0));
        newRole.setVersion(Constant.ROLE_VERSION);
        newRole.setTenantId(tenantId);
        int insertFlag = this.roleGateway.insert(newRole);
        if (insertFlag > Constant.ZERO) {
            flag = this.doUpdateRole(role, newRole);
        }
        if (!flag) {
            return new ReturnVO(ReturnEnum.ERROR_CRON);
        }
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    private boolean doUpdateRole(RoleCmd roleCmd, Role newRole) {
        User currentUser = this.commonService.getCurrentUser();
        Long tenantId = currentUser.getTenantId();
        boolean flag = false;
        List roleRel = roleCmd.getPermId();
        for (Long role : roleRel) {
            AdminRolePermRel rel = new AdminRolePermRel();
            rel.setPerId(role);
            rel.setRoleId(newRole.getId());
            rel.setTenantId(tenantId);
            flag = this.adminRolePermRelGateway.inserAdminRolePermRel(rel);
        }
        return flag;
    }

    private String doGenerateRoleCode(String userName) {
        Random random = new Random();
        int randomNumber = random.nextInt(9000) + 1000;
        String pinyinstr = "";
        char[] newChar = userName.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < newChar.length; ++i) {
            if (newChar[i] > '\u0080') {
                try {
                    pinyinstr = pinyinstr + PinyinHelper.toHanyuPinyinStringArray((char)newChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinstr = pinyinstr + newChar[i];
        }
        return pinyinstr.toUpperCase() + randomNumber;
    }
}

