/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.role;

import com.cicv.foton.admin.commond.role.RoleDeleteByIdCmdExe;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.RoleGateway;
import com.cicv.foton.admin.domain.system.Role;
import com.cicv.foton.admin.dto.RoleCmd;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class RoleDeleteCmdExe {
    private static final Logger log = LoggerFactory.getLogger(RoleDeleteCmdExe.class);
    @Resource
    private RoleGateway roleGateway;
    @Resource
    private RoleDeleteByIdCmdExe roleDeleteByIdCmdExe;

    public ReturnVO<Boolean> execute(RoleCmd role) {
        boolean flag = false;
        if (Objects.isNull(role)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        Role oldRole = this.roleGateway.selectRoleById(role.getId());
        if (0 == oldRole.getIsEnabled()) {
            throw new BaseBusinessException(CommonEnum.ROLE_START_REPEAT.getCode(), CommonEnum.ROLE_START_REPEAT.getMessage());
        }
        oldRole.setDeleted(Constant.DELETE);
        User currentUser = (User)AuthorityUtils.getCurrentUser();
        oldRole.setUpdateUser(currentUser.getUsername());
        oldRole.setUpdateTime(new Date());
        this.roleGateway.deleteById(oldRole);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }
}

