/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.resource;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.OrderEnum;
import com.cicv.foton.admin.domain.gateway.ServiceInfoGateway;
import com.cicv.foton.admin.domain.system.ServiceInfo;
import com.cicv.foton.admin.dto.ResourceCmd;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourcePageCmdExe {
    @Autowired
    ServiceInfoGateway serviceInfoGateway;

    public IPage<ServiceInfo> execute(ResourceCmd cmd) {
        Long current = cmd.getCurrent();
        Long size = cmd.getSize();
        Long id = cmd.getId();
        Integer srvStatus = cmd.getSrvStatus();
        Integer orderType = cmd.getOrderType();
        if (Objects.isNull(current) || Objects.isNull(size)) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (!Objects.isNull(id)) {
            lambdaQueryWrapper.eq(BaseEntity::getId, (Object)id);
        }
        if (!Objects.isNull(srvStatus)) {
            lambdaQueryWrapper.eq(ServiceInfo::getSrvStatus, (Object)srvStatus);
        }
        if (!Objects.isNull(orderType)) {
            if (Objects.equals(OrderEnum.ASC.getOrderType(), orderType)) {
                lambdaQueryWrapper.orderByAsc(ServiceInfo::getReleaseTime);
            } else if (Objects.equals(OrderEnum.DESC.getOrderType(), orderType)) {
                lambdaQueryWrapper.orderByDesc(ServiceInfo::getReleaseTime);
            }
        }
        lambdaQueryWrapper.orderByAsc(CommonEntity::getTenantId);
        lambdaQueryWrapper.orderByDesc(ServiceInfo::getReleaseTime);
        IPage queryServiceInfoPage = this.serviceInfoGateway.queryServiceInfoPage(new Page(current.longValue(), (Objects.equals(Constant.LONG_ZORE, size) ? Constant.DEFAULT_SIZE : size).longValue()), lambdaQueryWrapper);
        System.out.println(JSON.toJSONString((Object)queryServiceInfoPage));
        return queryServiceInfoPage;
    }
}

