/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.permission;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.PermInfoGateway;
import com.cicv.foton.admin.domain.system.PermInfo;
import com.cicv.foton.admin.dto.PermissionCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionUpdateCmdExe {
    @Autowired
    PermInfoGateway permInfoGateway;
    @Autowired
    CommonService commonService;

    public void execute(PermissionCmd cmd) {
        String name = cmd.getName();
        Long applyId = cmd.getApplyId();
        Long id = cmd.getId();
        List resourceList = cmd.getSelectedResourceList();
        List halfResourceList = cmd.getHalfResourceList();
        if (StringUtils.isBlank((CharSequence)name) || Objects.isNull(id) || Objects.isNull(applyId) || Objects.isNull(resourceList) || Objects.isNull(halfResourceList)) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        this.updatePermInfo(id, name, applyId, cmd.getRemark());
        this.permInfoGateway.deleteResourceRelByPermId(id);
        this.commonService.savaPermRel(id, applyId, resourceList, halfResourceList);
    }

    private void updatePermInfo(Long id, String name, Long applyId, String remark) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(PermInfo::getAppId, (Object)applyId)).set(PermInfo::getName, (Object)name)).set(PermInfo::getRemark, (Object)remark)).eq(BaseEntity::getId, (Object)id);
        this.permInfoGateway.updatePermInfo(wrapper);
    }
}

