/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.permission;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.IsMasterEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.PermInfoGateway;
import com.cicv.foton.admin.domain.system.dataobject.PermissionDO;
import com.cicv.foton.admin.dto.PermissionCmd;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionPageCmdExe {
    @Autowired
    PermInfoGateway permInfoGateway;
    @Autowired
    AdminMemberGateway adminMemberGateway;

    public IPage<PermissionDO> execute(PermissionCmd cmd) {
        Long current = cmd.getCurrent();
        Long size = cmd.getSize();
        PermissionDO permissionDO = new PermissionDO();
        BeanUtils.copyProperties((Object)cmd, (Object)permissionDO);
        permissionDO.setAppId(cmd.getApplyId());
        if (Objects.isNull(current) || Objects.isNull(size)) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        Page page = new Page(current.longValue(), (Objects.equals(Constant.LONG_ZORE, size) ? Constant.DEFAULT_SIZE : size).longValue());
        if (Objects.isNull(cmd.getMemberId())) {
            return this.permInfoGateway.page(page, permissionDO);
        }
        Integer isMaster = cmd.getIsMaster();
        if (Objects.equals(IsMasterEnum.TENANT_USER.getMasterType(), isMaster)) {
            return this.adminMemberGateway.getPermByMemberIdPage(page, permissionDO);
        }
        return this.adminMemberGateway.getPermByTenantIdPage(page, permissionDO);
    }
}

