/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.permission;

import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AppDpColGateway;
import com.cicv.foton.admin.domain.gateway.AppDpRowGateway;
import com.cicv.foton.admin.domain.gateway.DictGateway;
import com.cicv.foton.admin.domain.gateway.ServiceModelMetaDateGateway;
import com.cicv.foton.admin.domain.system.Dict;
import com.cicv.foton.admin.domain.system.dataobject.AppDpColCO;
import com.cicv.foton.admin.domain.system.dataobject.AppRowCO;
import com.cicv.foton.admin.domain.system.dataobject.AppRowOrColDO;
import com.cicv.foton.admin.domain.system.dataobject.ServiceModelMetadataDO;
import com.cicv.foton.admin.dto.PermissionAssignmentCmd;
import com.cicv.foton.admin.dto.clientobject.PermissionDataModelCO;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionAssignmentQueryRowColumnCmdExe {
    @Resource
    private AppDpRowGateway appDpRowGateway;
    @Resource
    private ServiceModelMetaDateGateway serviceModelMetaDateGateway;
    @Autowired
    private CommonService commonService;
    @Autowired
    private AppDpColGateway appDpColGateway;
    @Resource
    private DictGateway dictGateway;

    public PermissionDataModelCO execute(PermissionAssignmentCmd permissionCmd) {
        if (ObjUtil.isNull((Object)permissionCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        Long id = permissionCmd.getId();
        Long srvId = permissionCmd.getSrvId();
        Long srvModelId1 = permissionCmd.getSrvModelId();
        Long dpType = permissionCmd.getOrgType();
        if (!Objects.isNull(id) && !Objects.isNull(dpType)) {
            ArrayList<ServiceModelMetadataDO> list = new ArrayList<ServiceModelMetadataDO>();
            List<ServiceModelMetadataDO> models = this.modelMetadata(srvModelId1);
            for (ServiceModelMetadataDO model : models) {
                Long srvModelId = model.getId();
                AppDpColCO colList = this.col(srvModelId, id, dpType, permissionCmd.getOrgType());
                if (ObjUtil.isNotNull((Object)colList)) {
                    model.setCol(colList);
                    model.setColId(colList.getId());
                }
                list.add(model);
            }
            List<AppRowCO> rowList = this.row(id, dpType, permissionCmd.getOrgType());
            Map<String, List<Dict>> dic = this.commonService.getDic();
            List rule = this.dictGateway.selectDictList((QueryWrapper)new QueryWrapper().eq((Object)"dict_type", (Object)"desen_rules"));
            return new PermissionDataModelCO(list, rowList, null, dic.get("rowOperator"), rule);
        }
        return null;
    }

    private List<ServiceModelMetadataDO> modelMetadata(Long srvModelId) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"is_deleted", (Object)0);
        qw.eq((Object)"srv_model_id", (Object)srvModelId);
        List model = this.serviceModelMetaDateGateway.queryServiceModelMetaDate(qw);
        ArrayList<ServiceModelMetadataDO> list = new ArrayList<ServiceModelMetadataDO>();
        model.stream().forEach(mode -> {
            ServiceModelMetadataDO modelMeta = new ServiceModelMetadataDO();
            BeanUtils.copyProperties((Object)mode, (Object)modelMeta);
            list.add(modelMeta);
        });
        return list;
    }

    private List<AppRowCO> row(Long id, Long dpType, Long orgType) {
        AppRowOrColDO row = new AppRowOrColDO();
        row.setId(id);
        if (dpType == Constant.ORG_TYPE) {
            row.setSqlDef("org_id");
        } else {
            row.setSqlDef("group_id");
        }
        row.setOrgType(orgType);
        ArrayList<AppRowCO> list = new ArrayList<AppRowCO>();
        List appRowCOS = this.appDpRowGateway.queryAppDpRowmodelList(row);
        for (AppRowCO appRowCO : appRowCOS) {
            Long dictOperatorId = appRowCO.getDictOperatorId();
            Dict dict = this.dictGateway.selectDictById(dictOperatorId);
            String value = dict.getValue();
            appRowCO.setDictNumber(value);
            list.add(appRowCO);
        }
        return list;
    }

    private AppDpColCO col(Long srvModelId, Long id, Long dpType, Long orgType) {
        AppRowOrColDO col = new AppRowOrColDO();
        col.setId(id);
        col.setMetadataId(srvModelId);
        col.setOrgType(dpType);
        if (dpType == Constant.ORG_TYPE) {
            col.setSqlDef("org_id");
        } else {
            col.setSqlDef("group_id");
        }
        col.setOrgType(orgType);
        AppDpColCO appDpColCO = this.appDpColGateway.queryAppDpColModelList(col);
        if (ObjUtil.isNull((Object)appDpColCO)) {
            return null;
        }
        String deseType = ObjUtil.isNull((Object)appDpColCO.getStartInclude()) ? "overall_repla" : "partial_repla";
        appDpColCO.setDeseType(deseType);
        return appDpColCO;
    }
}

