/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.permission;

import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.OrgGateway;
import com.cicv.foton.admin.domain.gateway.ServiceModelDataGroupGateway;
import com.cicv.foton.admin.domain.system.Org;
import com.cicv.foton.admin.domain.system.ServiceModelDataGroup;
import com.cicv.foton.admin.dto.PermissionAssignmentCmd;
import com.cicv.foton.admin.dto.clientobject.PermModelCO;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.core.utils.TreeUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PermissionAssignmentGroupTreeCmeExe {
    private static final Logger log = LoggerFactory.getLogger(PermissionAssignmentGroupTreeCmeExe.class);
    @Resource
    private OrgGateway orgGateway;
    @Resource
    private ServiceModelDataGroupGateway serviceModelDataGroupGateway;
    @Resource
    private CommonService commonService;

    public List<PermModelCO> execute(PermissionAssignmentCmd permissionCmd) {
        if (ObjUtil.isNull((Object)permissionCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        ArrayList<PermModelCO> list = new ArrayList<PermModelCO>();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.orderByAsc((Object)"parent_id");
        wrapper.eq((Object)"tenant_id", (Object)tenantId);
        wrapper.orderByAsc((Object)"parent_id");
        wrapper.orderByAsc((Object)"order_no");
        ArrayList<Org> orgList = new ArrayList<Org>();
        List orgs = this.orgGateway.selectList(wrapper);
        for (Org org : orgs) {
            org.setOrgType("1");
            orgList.add(org);
        }
        List tree = TreeUtils.list2Tree((List)orgs);
        if (ObjUtil.isNull((Object)tree)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_ORG_NULL.getCode(), CommonEnum.PERMSSION_NAME_ORG_NULL.getMessage());
        }
        PermModelCO modelOrg = new PermModelCO();
        modelOrg.setType(((Org)tree.get(0)).getName());
        modelOrg.setList(tree);
        list.add(modelOrg);
        QueryWrapper dataGroup = new QueryWrapper();
        dataGroup.orderByAsc((Object)"parent_id");
        Long modelId = permissionCmd.getId();
        if (ObjUtil.isNotNull((Object)modelId)) {
            dataGroup.eq((Object)"srv_model_id", (Object)modelId);
            ArrayList<ServiceModelDataGroup> groupList = new ArrayList<ServiceModelDataGroup>();
            List groups = this.serviceModelDataGroupGateway.queryServiceModelDataGroupList(dataGroup);
            for (ServiceModelDataGroup group : groups) {
                group.setOrgType("2");
                groupList.add(group);
            }
            List ts = TreeUtils.list2Tree(groupList);
            ts.stream().forEach(serviceModelDataGroup -> {
                String name = serviceModelDataGroup.getName();
                PermModelCO model = new PermModelCO();
                model.setType(name);
                model.setList(serviceModelDataGroup.getChildren());
                list.add(model);
            });
        }
        return list;
    }
}

