/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.permission;

import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AppDpColGateway;
import com.cicv.foton.admin.domain.gateway.AppDpRowGateway;
import com.cicv.foton.admin.domain.gateway.DictGateway;
import com.cicv.foton.admin.domain.gateway.RedisGateway;
import com.cicv.foton.admin.domain.gateway.ServiceInfoGateway;
import com.cicv.foton.admin.domain.gateway.ServiceModelGateway;
import com.cicv.foton.admin.domain.gateway.ServiceModelMetaDateGateway;
import com.cicv.foton.admin.domain.system.AppDpCol;
import com.cicv.foton.admin.domain.system.AppDpRow;
import com.cicv.foton.admin.domain.system.Dict;
import com.cicv.foton.admin.domain.system.ServiceInfo;
import com.cicv.foton.admin.domain.system.ServiceModel;
import com.cicv.foton.admin.domain.system.ServiceModelMetaDate;
import com.cicv.foton.admin.domain.system.dataobject.AppDpColCO;
import com.cicv.foton.admin.dto.AppPermAssingnCmd;
import com.cicv.foton.admin.dto.ColRedisCmd;
import com.cicv.foton.admin.dto.RowCmd;
import com.cicv.foton.admin.dto.RowRedisCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionAssignmentDataModelCmeExe {
    private static final Logger log = LoggerFactory.getLogger(PermissionAssignmentDataModelCmeExe.class);
    @Resource
    private AppDpColGateway appDpColGateway;
    @Resource
    private AppDpRowGateway appDpRowGateway;
    @Resource
    private RedisGateway redisGateway;
    @Resource
    private ServiceInfoGateway serviceInfoGateway;
    @Resource
    private DictGateway dictGateway;
    @Resource
    private ServiceModelMetaDateGateway serviceModelMetaDateGateway;
    @Resource
    private CommonService commonService;
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Resource
    private ServiceModelGateway serviceModelGateway;

    @Transactional(rollbackFor={Exception.class})
    public void execute(AppPermAssingnCmd appModelCmd) {
        if (Objects.isNull(appModelCmd)) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_TENANT_NULL.getCode(), CommonEnum.PERMSSION_NAME_TENANT_NULL.getMessage());
        }
        this.doUpdateAppDpRow(appModelCmd);
        this.doUpdateAppDpCol(appModelCmd);
    }

    @Transactional(rollbackFor={Exception.class})
    public void doUpdateAppDpRow(AppPermAssingnCmd appModelCmd) {
        if (ObjUtil.isNull((Object)appModelCmd)) {
            return;
        }
        Long srvModelId = appModelCmd.getSrvModelId();
        User currentUser = this.commonService.getCurrentUser();
        Long tenantId = currentUser.getTenantId();
        Date date = new Date();
        String username = currentUser.getUsername();
        Long groupId = appModelCmd.getOrgId();
        Long orgType = Long.valueOf(appModelCmd.getOrgType());
        Long orgId = appModelCmd.getOrgId();
        this.appDpRowGateway.deleteGruopId(orgId, orgType);
        Long srvId = appModelCmd.getSrvId();
        ServiceInfo serviceInfo = this.doServiceInfo(srvId);
        String name = serviceInfo.getName();
        Long modelId = appModelCmd.getSrvModelId();
        ServiceModel serviceModel = this.doServiceMOdel(modelId);
        ServiceModel model = this.doServiceModel(appModelCmd.getSrvModelId());
        String uid = model.getUid();
        String modelName = null;
        if (ObjUtil.isNotNull((Object)serviceModel)) {
            modelName = serviceModel.getModelName();
        }
        ArrayList rowList = new ArrayList();
        appModelCmd.getRowMetadata().stream().forEach(row -> {
            String dictNumber = row.getDictNumber();
            Long dictOperatorId = null;
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"value", (Object)dictNumber);
            Dict dict = this.dictGateway.queryDictByName(qw);
            if (ObjUtil.isNotNull((Object)dict)) {
                QueryWrapper value = new QueryWrapper();
                value.eq((Object)"label", (Object)dictNumber);
                Dict lable = this.dictGateway.queryDictByName(qw);
                dictOperatorId = lable.getId();
            } else {
                dictOperatorId = dict.getId();
            }
            AppDpRow appDpRow = new AppDpRow();
            BeanUtils.copyProperties((Object)appModelCmd, (Object)appDpRow);
            BeanUtils.copyProperties((Object)row, (Object)appDpRow);
            if (orgType == Constant.ORG_TYPE) {
                appDpRow.setOrgId(appModelCmd.getOrgId());
            } else {
                appDpRow.setGroupId(appModelCmd.getOrgId());
            }
            appDpRow.setId(null);
            appDpRow.setDictOperatorId(dictOperatorId);
            appDpRow.setDpType(orgType);
            appDpRow.setModelMetaId(row.getModelMetaId());
            appDpRow.setTenantId(tenantId);
            appDpRow.setCreateUser(username);
            appDpRow.setCreateTime(date);
            appDpRow.setDeleted(Constant.ZERO);
            rowList.add(appDpRow);
            this.appDpRowGateway.insertAppDpRow(appDpRow);
            log.info(" insert row table \u3002\u3002\u3002");
        });
        this.doAppDpRowAddRedis(appModelCmd.getRowMetadata(), name, orgId, modelName);
        this.doGroupRowRedis(appModelCmd.getRowMetadata(), name, uid, modelName);
    }

    @Transactional(rollbackFor={Exception.class})
    public void doUpdateAppDpCol(AppPermAssingnCmd appModelCmd) {
        if (ObjUtil.isNull((Object)appModelCmd)) {
            return;
        }
        User currentUser = this.commonService.getCurrentUser();
        Long tenantId = currentUser.getTenantId();
        Date date = new Date();
        String username = currentUser.getUsername();
        Long orgId = appModelCmd.getOrgId();
        Long srvModelId = appModelCmd.getSrvId();
        ServiceInfo serviceInfo = this.doServiceInfo(srvModelId);
        String name = serviceInfo.getName();
        ServiceModel model = this.doServiceModel(appModelCmd.getSrvModelId());
        String uid = model.getUid();
        Long modelId = appModelCmd.getSrvModelId();
        ServiceModel serviceModel = this.doServiceMOdel(modelId);
        String modelName = null;
        if (ObjUtil.isNotNull((Object)serviceModel)) {
            modelName = serviceModel.getModelName();
        }
        ArrayList<AppDpCol> listCol = new ArrayList<AppDpCol>();
        Long orgType = Long.valueOf(appModelCmd.getOrgType());
        appModelCmd.getModelMetadata().stream().forEach(col -> {
            AppDpColCO appCol = col.getCol();
            if (ObjUtil.isNotNull((Object)col.getColId())) {
                AppDpCol dpCol = this.appDpColGateway.queryAppDpColById(col.getColId());
                if (ObjUtil.isNotNull((Object)dpCol)) {
                    if (ObjUtil.isNotNull((Object)appCol)) {
                        BeanUtils.copyProperties((Object)col.getCol(), (Object)dpCol);
                    }
                    dpCol.setUpdateTime(date);
                    dpCol.setUpdateUser(username);
                    listCol.add(dpCol);
                    this.appDpColGateway.updateAppDpColById(dpCol);
                }
            } else if (ObjUtil.isNotNull((Object)appCol)) {
                AppDpCol insertCol = new AppDpCol();
                BeanUtils.copyProperties((Object)appModelCmd, (Object)insertCol);
                BeanUtils.copyProperties((Object)col.getCol(), (Object)insertCol);
                if (orgType == Constant.ORG_TYPE) {
                    insertCol.setOrgId(appModelCmd.getOrgId());
                } else {
                    insertCol.setGroupId(appModelCmd.getOrgId());
                }
                insertCol.setDpType(orgType);
                listCol.add(insertCol);
                insertCol.setModelMetaId(col.getId());
                insertCol.setCreateTime(date);
                insertCol.setCreateUser(username);
                insertCol.setTenantId(tenantId);
                Integer deseType = col.getRowType().equals("dim") ? Constant.DESE_TYPE : Constant.DESE_TYPE_IN;
                insertCol.setDeseType(deseType);
                this.appDpColGateway.insertAppDpCol(insertCol);
            }
            log.info(" insert col table \u3002\u3002\u3002");
        });
        this.doAppDpColAddRedis(listCol, name, orgId, modelName);
        this.doGroupColdRedis(listCol, name, uid, modelName);
    }

    private ServiceModel doServiceMOdel(Long modelId) {
        return this.serviceModelGateway.queryServiceModel((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServiceModel::getId, (Object)modelId));
    }

    void doAppDpRowAddRedis(List<RowCmd> rowMetadata, String name, Long orgId, String modelName) {
        String redisKey = "foton:application:datapermission:orgId:" + name + ":" + modelName + ":" + orgId + ":row";
        HashMap<String, RowRedisCmd> map = new HashMap<String, RowRedisCmd>();
        for (RowCmd appDpRow : rowMetadata) {
            RowRedisCmd row = new RowRedisCmd();
            Long modelMetaId = appDpRow.getModelMetaId();
            ServiceModelMetaDate metaDate = this.doServiceModelMetaDate(modelMetaId);
            String fieldNote = metaDate.getFieldNote();
            row.setOper(appDpRow.getDictNumber());
            row.setVal(appDpRow.getCondValue());
            map.put(fieldNote, row);
            this.dpRedisTemplate.delete((Object)(redisKey + metaDate.getFieldName()));
            this.dpRedisTemplate.opsForHash().put((Object)redisKey, (Object)metaDate.getFieldName(), (Object)row);
        }
    }

    void doAppDpColAddRedis(List<AppDpCol> colList, String name, Long orgId, String modelName) {
        log.info(" begin redis table col \u3002\u3002\u3002");
        String key = "foton:application:datapermission:orgId:" + name + ":" + modelName + ":" + orgId + ":col";
        HashMap<String, ColRedisCmd> map = new HashMap<String, ColRedisCmd>();
        for (AppDpCol dpCol : colList) {
            Long modelMetaId = dpCol.getModelMetaId();
            ServiceModelMetaDate metaDate = this.doServiceModelMetaDate(modelMetaId);
            ColRedisCmd col = new ColRedisCmd();
            col.setDeseType(ObjUtil.isNull((Object)dpCol.getStartInclude()) ? Constant.COL_REPLIE : Constant.COL_DESE_TYPE);
            col.setStartInclude(ObjUtil.isNull((Object)dpCol.getStartInclude()) ? Constant.COL_DESE_TYPE : dpCol.getStartInclude());
            col.setEndExclude(ObjUtil.isNull((Object)dpCol.getEndExclude()) ? Constant.COL_DESE_TYPE : dpCol.getEndExclude());
            String fieldName = metaDate.getFieldName();
            col.setReplacedChar(dpCol.getReplacedChar());
            map.put(fieldName, col);
            this.dpRedisTemplate.delete((Object)(key + fieldName));
            this.dpRedisTemplate.opsForHash().put((Object)key, (Object)fieldName, (Object)col);
        }
        log.info(" end redis table col \u3002\u3002\u3002");
    }

    void doGroupRowRedis(List<RowCmd> rowMetadata, String name, String uId, String modelName) {
        String redisKey = "foton:application:datapermission:datagroup:" + name + ":" + modelName + ":" + uId + ":row";
        HashMap<String, RowRedisCmd> map = new HashMap<String, RowRedisCmd>();
        for (RowCmd appDpRow : rowMetadata) {
            RowRedisCmd row = new RowRedisCmd();
            Long modelMetaId = appDpRow.getModelMetaId();
            ServiceModelMetaDate metaDate = this.doServiceModelMetaDate(modelMetaId);
            String fieldNote = metaDate.getFieldNote();
            row.setOper(appDpRow.getDictNumber());
            row.setVal(appDpRow.getCondValue());
            map.put(fieldNote, row);
            this.dpRedisTemplate.delete((Object)(redisKey + metaDate.getFieldName()));
            this.dpRedisTemplate.opsForHash().put((Object)redisKey, (Object)metaDate.getFieldName(), (Object)row);
        }
    }

    void doGroupColdRedis(List<AppDpCol> colList, String name, String uid, String modelName) {
        log.info(" begin redis table \u3002\u3002\u3002");
        String applicationName = SdkContext.getApplicationName();
        String key = "foton:application:datapermission:datagroup:" + name + ":" + modelName + ":" + uid + ":col";
        HashMap<String, ColRedisCmd> map = new HashMap<String, ColRedisCmd>();
        for (AppDpCol dpCol : colList) {
            Long modelMetaId = dpCol.getModelMetaId();
            ServiceModelMetaDate metaDate = this.doServiceModelMetaDate(modelMetaId);
            ColRedisCmd col = new ColRedisCmd();
            col.setDeseType(ObjUtil.isNull((Object)dpCol.getStartInclude()) ? Constant.COL_REPLIE : Constant.COL_DESE_TYPE);
            col.setStartInclude(ObjUtil.isNull((Object)dpCol.getStartInclude()) ? Constant.COL_DESE_TYPE : dpCol.getStartInclude());
            col.setEndExclude(ObjUtil.isNull((Object)dpCol.getEndExclude()) ? Constant.COL_DESE_TYPE : dpCol.getEndExclude());
            String fieldName = metaDate.getFieldName();
            col.setReplacedChar(dpCol.getReplacedChar());
            map.put(fieldName, col);
            this.dpRedisTemplate.delete((Object)(key + fieldName));
            this.dpRedisTemplate.opsForHash().put((Object)key, (Object)fieldName, (Object)col);
        }
        log.info(" end redis table \u3002\u3002\u3002");
    }

    private ServiceInfo doServiceInfo(Long id) {
        return this.serviceInfoGateway.queryServiceInfoById((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id));
    }

    private ServiceModelMetaDate doServiceModelMetaDate(Long modelMetaId) {
        return this.serviceModelMetaDateGateway.queryServiceMOdelMateDateBeaseById(modelMetaId);
    }

    private ServiceModel doServiceModel(Long id) {
        return this.serviceModelGateway.queryServiceModel((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServiceModel::getId, (Object)id));
    }
}

