/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.permission;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.PermInfoGateway;
import com.cicv.foton.admin.domain.system.PermInfo;
import com.cicv.foton.admin.dto.PermissionCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionAddCmdExe {
    @Autowired
    PermInfoGateway permInfoGateway;
    @Autowired
    CommonService commonService;

    public void execute(PermissionCmd cmd) {
        String name = cmd.getName();
        Long applyId = cmd.getApplyId();
        List resourceList = cmd.getSelectedResourceList();
        List halfResourceList = cmd.getHalfResourceList();
        if (StringUtils.isBlank((CharSequence)name) || Objects.isNull(applyId) || Objects.isNull(resourceList) || Objects.isNull(halfResourceList)) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        List selectList = this.permInfoGateway.selectList((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PermInfo::getName, (Object)name));
        if (!selectList.isEmpty()) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_NAME_USED.getCode(), CommonEnum.PERMSSION_NAME_USED.getMessage());
        }
        Long perId = this.savePermInfo(name, applyId, cmd.getRemark());
        this.commonService.savaPermRel(perId, applyId, resourceList, halfResourceList);
    }

    private Long savePermInfo(String name, Long applyId, String remark) {
        PermInfo permInfo = new PermInfo();
        permInfo.setName(name);
        permInfo.setAppId(applyId);
        permInfo.setRemark(remark);
        this.permInfoGateway.insetPermInfo(permInfo);
        return permInfo.getId();
    }
}

