/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.org;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.OrgGateway;
import com.cicv.foton.admin.domain.system.Org;
import com.cicv.foton.admin.dto.OrgCmd;
import com.cicv.foton.admin.dto.clientobject.OrgCo;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.core.utils.TreeUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgQueryTreesCmdExe {
    @Autowired
    private OrgGateway orgGateway;
    @Autowired
    private AdminMemberGateway adminMemberGateway;
    @Autowired
    private CommonService commonService;
    private static final String[] CHINESE_NUMBERS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};

    public List<OrgCo> execute(OrgCmd orgCmd) {
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        Org parent = null;
        if (orgCmd.getParentId() != null && (parent = this.orgGateway.selectById(orgCmd.getParentId())) == null) {
            throw new BaseBusinessException("601", "\u6240\u6307\u5b9a\u7684\u4e0a\u7ea7\u673a\u6784\u4e0d\u5b58\u5728\u3002");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_id", (Object)tenantId);
        if (StringUtils.isNotEmpty((String)orgCmd.getName())) {
            wrapper.like((Object)"name", (Object)orgCmd.getName());
        }
        if (StringUtils.isNotEmpty((String)orgCmd.getCode())) {
            wrapper.like((Object)"code", (Object)orgCmd.getCode());
        }
        if (parent != null) {
            wrapper.likeLeft((Object)"code", (Object)parent.getCode());
        }
        wrapper.orderByDesc((Object)"parent_id");
        List orgs = this.orgGateway.selectList(wrapper);
        orgs.sort(Comparator.comparingLong(org -> this.getParentLevel((Org)org, orgs)));
        Map<Long, Integer> levelsMap = this.getOrgLevel(orgs);
        ArrayList<OrgCo> orgCoList = new ArrayList<OrgCo>();
        for (Org org2 : orgs) {
            StringBuilder result = new StringBuilder();
            OrgCo orgCo = new OrgCo();
            BeanUtils.copyProperties((Object)org2, (Object)orgCo);
            Integer level = levelsMap.get(org2.getId());
            String numberStr = String.valueOf(level);
            int length = numberStr.length();
            for (int i = 0; i < length; ++i) {
                int digit = Character.getNumericValue(numberStr.charAt(i));
                result.append(CHINESE_NUMBERS[digit]);
            }
            String levelString = result.toString();
            orgCo.setOrgLevel(levelString + "\u7ea7\u90e8\u95e8");
            if (!Objects.isNull(orgCmd.getIsMember())) {
                orgCo.setMemberCount(Long.valueOf(this.adminMemberGateway.memberCount(org2.getId(), tenantId)));
            }
            orgCoList.add(orgCo);
        }
        return TreeUtils.list2Tree(orgCoList);
    }

    private int getParentLevel(Org org, List<Org> orgs) {
        if (org.getParentId() == null) {
            return 0;
        }
        for (Org parent : orgs) {
            if (!parent.getId().equals(org.getParentId())) continue;
            return 1 + this.getParentLevel(parent, orgs);
        }
        return 0;
    }

    private Map<Long, Integer> getOrgLevel(List<Org> orgs) {
        HashMap<Long, Integer> levels = new HashMap<Long, Integer>();
        for (Org org : orgs) {
            int parentLevel = levels.getOrDefault(org.getParentId(), 0);
            int currentLevel = parentLevel + 1;
            levels.put(org.getId(), currentLevel);
        }
        return levels;
    }
}

