/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.org;

import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminOrgGateway;
import com.cicv.foton.admin.domain.system.AdminOrg;
import com.cicv.foton.admin.dto.AdminOrgInfoCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AdminOrgUpdateCmdExe {
    @Resource
    private AdminOrgGateway adminOrgGateway;
    @Resource
    private CommonService commonService;

    public Boolean execute(AdminOrgInfoCmd cmd) {
        AdminOrg adminOrg = new AdminOrg();
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        if (Objects.isNull(tenantId)) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        if (cmd.getId().equals(cmd.getParentId())) {
            throw new BaseBusinessException(CommonEnum.PARENT_ORG_THE_SAME.getCode(), CommonEnum.PARENT_ORG_THE_SAME.getMessage());
        }
        this.adminOrgGateway.selectByNameUpdate(cmd.getName(), cmd.getId(), tenantId);
        if (null != cmd.getParentId() && 0L != cmd.getParentId()) {
            AdminOrg parentOrg = this.adminOrgGateway.selectById(cmd.getParentId());
            adminOrg.setParentId(cmd.getParentId());
            adminOrg.setLevel(Integer.valueOf(parentOrg.getLevel() + 1));
        } else {
            adminOrg.setParentId(Constant.PARENTID);
            adminOrg.setLevel(Constant.LEVEL);
        }
        adminOrg.setUpdateTime(new Date());
        adminOrg.setDescription(cmd.getDescription());
        adminOrg.setId(cmd.getId());
        adminOrg.setName(cmd.getName());
        User currentUser = SdkContext.getCurrentUser();
        adminOrg.setUpdateUser(currentUser.getUsername());
        return this.adminOrgGateway.updateOrg(adminOrg);
    }
}

