/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.org;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminOrgGateway;
import com.cicv.foton.admin.domain.system.AdminOrg;
import com.cicv.foton.admin.dto.AdminOrgInfoCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Date;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AdminOrgSaveCmdExe {
    @Resource
    private AdminOrgGateway adminOrgGateway;
    @Resource
    private CommonService commonService;

    public Boolean execute(AdminOrgInfoCmd cmd) {
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        if (Objects.isNull(tenantId)) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        AdminOrg adminOrg = new AdminOrg();
        this.adminOrgGateway.selectByName(cmd.getName(), tenantId);
        if (null != cmd.getParentId()) {
            this.adminOrgGateway.selectById(cmd.getParentId());
            adminOrg.setParentId(cmd.getParentId());
            AdminOrg org = this.adminOrgGateway.selectById(cmd.getParentId());
            adminOrg.setLevel(Integer.valueOf(org.getLevel() + 1));
        } else {
            adminOrg.setLevel(Constant.LEVEL);
            adminOrg.setParentId(Constant.PARENTID);
        }
        User currentUser = SdkContext.getCurrentUser();
        adminOrg.setUpdateUser(currentUser.getUsername());
        adminOrg.setCreateUser(currentUser.getUsername());
        adminOrg.setCreateTime(new Date());
        adminOrg.setUpdateTime(new Date());
        adminOrg.setName(cmd.getName());
        adminOrg.setTenantId(tenantId);
        adminOrg.setOrderNo(Constant.ORDERNO);
        adminOrg.setIsDeleted(Constant.IS_DELETE);
        adminOrg.setDescription(cmd.getDescription());
        long id = IdWorker.getId();
        adminOrg.setId(Long.valueOf(id));
        Random random = new Random();
        int num = random.nextInt(900000) + 100000;
        adminOrg.setCode(String.valueOf(num));
        return this.adminOrgGateway.saveOrg(adminOrg);
    }
}

