/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.org;

import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminOrgGateway;
import com.cicv.foton.admin.domain.system.AdminOrg;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AdminOrgDeleteCmdExe {
    @Resource
    private AdminOrgGateway adminOrgGateway;
    @Resource
    private CommonService commonService;
    @Resource
    private AdminMemberGateway adminMemberGateway;

    public Boolean execute(Long id) {
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        if (Objects.isNull(tenantId)) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        List adminOrgList = this.adminOrgGateway.selectList();
        HashSet<Long> adminOrgIds = new HashSet<Long>();
        this.queryChildOrgId(id, adminOrgList, adminOrgIds);
        adminOrgIds.add(id);
        Boolean userFlag = this.adminMemberGateway.selectUserByOrg(adminOrgIds);
        if (userFlag.booleanValue()) {
            throw new BaseBusinessException(CommonEnum.USER_STOP_DELETE_ORG_THE_SAME.getCode(), CommonEnum.USER_STOP_DELETE_ORG_THE_SAME.getMessage());
        }
        Boolean flag = this.adminOrgGateway.selectByParentId(id);
        if (flag.booleanValue()) {
            List<Long> subsetData = this.getSubsetData(adminOrgList, id);
            this.adminOrgGateway.deleteBatchById(subsetData);
        }
        return this.adminOrgGateway.deleteOrg(id);
    }

    private List<Long> getSubsetData(List<AdminOrg> orgList, Long parentId) {
        ArrayList<Long> subset = new ArrayList<Long>();
        for (AdminOrg org : orgList) {
            if (!org.getParentId().equals(parentId)) continue;
            subset.add(org.getId());
            subset.addAll(this.getSubsetData(orgList, org.getId()));
        }
        return subset;
    }

    private void queryChildOrgId(Long id, List<AdminOrg> adminOrgList, Set<Long> adminOrgIds) {
        for (AdminOrg adminOrg : adminOrgList) {
            if (null == adminOrg.getParentId() || !adminOrg.getParentId().equals(id)) continue;
            adminOrgIds.add(adminOrg.getId());
            this.queryChildOrgId(adminOrg.getId(), adminOrgList, adminOrgIds);
        }
    }
}

