/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.messageBox;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminMessage;
import com.cicv.foton.admin.domain.utils.DateUtil;
import com.cicv.foton.admin.dto.MessageBoxCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessagePageCmdExe {
    @Autowired
    AdminUserGateway adminUserGateway;
    @Autowired
    CommonService commonService;

    public IPage<AdminMessage> execute(MessageBoxCmd cmd) {
        Long current = cmd.getCurrent();
        Long size = cmd.getSize();
        if (Objects.isNull(current) || Objects.isNull(size)) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        User user = this.commonService.getCurrentUser();
        Page page = new Page(cmd.getCurrent().longValue(), cmd.getSize().longValue());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminMessage::getRecipientId, (Object)user.getId());
        String startTime = cmd.getStartTime();
        String endTime = cmd.getEndTime();
        Integer msgStatus = cmd.getMsgStatus();
        if (StringUtils.isNotBlank((String)startTime)) {
            wrapper.ge(BaseEntity::getCreateTime, (Object)DateUtil.strToDate((String)startTime));
        }
        if (StringUtils.isNotBlank((String)endTime)) {
            wrapper.le(BaseEntity::getCreateTime, (Object)DateUtil.strToDate((String)endTime));
        }
        if (!Objects.isNull(msgStatus)) {
            wrapper.eq(AdminMessage::getMsgStatus, (Object)msgStatus);
        }
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        return this.adminUserGateway.messagePage(page, wrapper);
    }
}

