/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.messageBox;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.IsConfimEnum;
import com.cicv.foton.admin.domain.enums.MsgStatusEnum;
import com.cicv.foton.admin.domain.enums.UserTypeEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.gateway.TenantGateway;
import com.cicv.foton.admin.domain.system.AdminMember;
import com.cicv.foton.admin.domain.system.AdminMessage;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.domain.system.Tenant;
import com.cicv.foton.admin.dto.MessageBoxCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageAgreeCmdExe {
    @Autowired
    AdminUserGateway adminUserGateway;
    @Autowired
    AdminMemberGateway adminMemberGateway;
    @Autowired
    CommonService commonService;
    @Autowired
    TenantGateway tenantGateway;

    public void execute(MessageBoxCmd cmd) {
        Long id = cmd.getId();
        Integer isConfim = cmd.getIsConfim();
        if (Objects.isNull(id) || Objects.isNull(isConfim)) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        AdminMessage adminMessage = this.adminUserGateway.messageById(id);
        switch (isConfim) {
            case 0: {
                this.adminMemberGateway.updatetByLambdaWrapp((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(AdminMember::getIsConfirm, (Object)IsConfimEnum.REFUSE.getStatus())).eq(BaseEntity::getId, (Object)adminMessage.getSourceId()));
                break;
            }
            case 1: {
                this.commonService.isExceedMemberCapacity(adminMessage.getTenantId());
                this.adminMemberGateway.updatetByLambdaWrapp((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(AdminMember::getIsConfirm, (Object)IsConfimEnum.AGREE.getStatus())).eq(BaseEntity::getId, (Object)adminMessage.getSourceId()));
                Long userType = UserTypeEnum.USER.getStatus();
                if (adminMessage.getType() == 2) {
                    userType = UserTypeEnum.SYSTEM.getStatus();
                    this.tenantGateway.updateByWrapper((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Tenant::getAdminMemberId, (Object)adminMessage.getRecipientId())).set(Tenant::getUserId, (Object)adminMessage.getRecipientId())).eq(BaseEntity::getId, (Object)adminMessage.getTenantId()));
                }
                this.adminUserGateway.updateUserInfo((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(AdminUser::getUserType, (Object)userType)).eq(BaseEntity::getId, (Object)adminMessage.getRecipientId()));
                break;
            }
        }
        this.adminUserGateway.messageUpdateByWarpper((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(AdminMessage::getMsgStatus, (Object)MsgStatusEnum.FINISH.getMsgStatus())).eq(BaseEntity::getId, (Object)id));
    }
}

