/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.member;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.IsMasterEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminMember;
import com.cicv.foton.admin.domain.system.AdminMemberRoleRel;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.AdminMeberCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AdminMemberUpdateCmdExe {
    @Resource
    AdminMemberGateway adminMemberGateway;
    @Resource
    AdminUserGateway adminUserGateway;
    @Resource
    CommonService commonService;

    public void execute(AdminMeberCmd adminMeberCmd) {
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        if (Objects.isNull(tenantId)) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        AdminMember adminMemberAdmin = this.adminMemberGateway.getAdminMemberByWrapper((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminMember::getUserId, (Object)user.getId())).eq(CommonEntity::getTenantId, (Object)tenantId)).eq(AdminMember::getIsMaster, (Object)IsMasterEnum.TENANT_ADMIN.getMasterType()));
        if (Objects.isNull(adminMemberAdmin)) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        Long id = adminMeberCmd.getId();
        String phone = adminMeberCmd.getPhone();
        String naCode = adminMeberCmd.getNaCode();
        List roleIdList = adminMeberCmd.getRoleIdList();
        if (Objects.isNull(id) || StringUtils.isBlank((String)adminMeberCmd.getCode()) || StringUtils.isBlank((String)adminMeberCmd.getRealName()) || StringUtils.isBlank((String)phone) || StringUtils.isBlank((String)naCode) || StringUtils.isBlank((String)adminMeberCmd.getEmail()) || Objects.isNull(adminMeberCmd.getOrgId()) || Objects.isNull(roleIdList) || roleIdList.isEmpty()) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        if (!Pattern.compile("[a-zA-Z0-9]+[\\.]{0,1}[a-zA-Z0-9]+@[a-zA-Z0-9]+\\.[a-zA-Z]+").matcher(adminMeberCmd.getEmail()).find()) {
            throw new BaseBusinessException(CommonEnum.EMAIL_FORMAT_ERROR.getCode(), CommonEnum.EMAIL_FORMAT_ERROR.getMessage());
        }
        AdminMember adminMemberByWrapper = this.adminMemberGateway.getAdminMemberByWrapper((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminMember::getPhone, (Object)phone)).eq(AdminMember::getNaCode, (Object)naCode));
        if (!Objects.isNull(adminMemberByWrapper)) {
            if (!Objects.equals(id, adminMemberByWrapper.getId())) {
                throw new BaseBusinessException(CommonEnum.MEMVER_IS_ABSENT.getCode(), CommonEnum.MEMVER_IS_ABSENT.getMessage());
            }
        } else {
            AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminUser::getPhone, (Object)phone)).eq(AdminUser::getNaCode, (Object)naCode));
            if (!Objects.isNull(adminUser)) {
                throw new BaseBusinessException(CommonEnum.PHONE_IS_EXIST_FOT_MEMBER.getCode(), CommonEnum.PHONE_IS_EXIST_FOT_MEMBER.getMessage());
            }
            this.adminUserGateway.updateUserInfo((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(AdminUser::getPassword, (Object)phone)).set(AdminUser::getNaCode, (Object)naCode)).eq(BaseEntity::getId, (Object)adminMeberCmd.getUserId()));
            this.sendMsg();
        }
        AdminMember adminMember = new AdminMember();
        BeanUtils.copyProperties((Object)adminMeberCmd, (Object)adminMember);
        adminMember.setTenantId(tenantId);
        this.adminMemberGateway.updatetById(adminMember);
        this.adminMemberGateway.deleteAdminMemberRoleRelByIds(id);
        for (Long roleId : roleIdList) {
            AdminMemberRoleRel adminMemberRoleRel = new AdminMemberRoleRel();
            adminMemberRoleRel.setMemberId(adminMember.getId());
            adminMemberRoleRel.setRoleId(roleId);
            adminMemberRoleRel.setTenantId(adminMember.getTenantId());
            this.adminMemberGateway.insertAdminMemberRoleRel(adminMemberRoleRel);
        }
    }

    private void sendMsg() {
    }
}

