/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.member;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.IsConfimEnum;
import com.cicv.foton.admin.domain.enums.IsMasterEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminMember;
import com.cicv.foton.admin.domain.system.AdminMemberRoleRel;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.AdminMeberCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AdminMemberAddCmdExe {
    @Resource
    AdminMemberGateway adminMemberGateway;
    @Resource
    AdminUserGateway adminUserGateway;
    @Resource
    CommonService commonService;

    public void execute(AdminMeberCmd adminMeberCmd) {
        User user = this.commonService.getCurrentUser();
        Long tenantId = user.getTenantId();
        if (Objects.isNull(tenantId)) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        AdminMember adminMemberAdmin = this.adminMemberGateway.getAdminMemberByWrapper((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminMember::getUserId, (Object)user.getId())).eq(CommonEntity::getTenantId, (Object)tenantId)).eq(AdminMember::getIsMaster, (Object)IsMasterEnum.TENANT_ADMIN.getMasterType()));
        if (Objects.isNull(adminMemberAdmin)) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_NOT_ADMIN.getCode(), CommonEnum.MEMBER_IS_NOT_ADMIN.getMessage());
        }
        List roleIdList = adminMeberCmd.getRoleIdList();
        String phone = adminMeberCmd.getPhone();
        String naCode = adminMeberCmd.getNaCode();
        String email = adminMeberCmd.getEmail();
        Long userId = adminMeberCmd.getUserId();
        if (StringUtils.isBlank((String)adminMeberCmd.getCode()) || Objects.isNull(adminMeberCmd.getUserId()) || StringUtils.isBlank((String)adminMeberCmd.getRealName()) || StringUtils.isBlank((String)adminMeberCmd.getPhone()) || StringUtils.isBlank((String)naCode) || StringUtils.isBlank((String)adminMeberCmd.getEmail()) || Objects.isNull(adminMeberCmd.getOrgId()) || Objects.isNull(roleIdList) || roleIdList.isEmpty()) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        this.commonService.isExceedMemberCapacity(tenantId);
        AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)userId));
        if (Objects.isNull(adminUser)) {
            throw new BaseBusinessException(CommonEnum.USER_IS_ABSENT.getCode(), CommonEnum.USER_IS_ABSENT.getMessage());
        }
        if (!Pattern.compile("^1([34578])\\d{9}$").matcher(phone).find()) {
            throw new BaseBusinessException(CommonEnum.PHONE_FORMAT_ERROR.getCode(), CommonEnum.PHONE_FORMAT_ERROR.getMessage());
        }
        if (!Pattern.compile("[a-zA-Z0-9]+[\\.]{0,1}[a-zA-Z0-9]+@[a-zA-Z0-9]+\\.[a-zA-Z]+").matcher(email).find()) {
            throw new BaseBusinessException(CommonEnum.EMAIL_FORMAT_ERROR.getCode(), CommonEnum.EMAIL_FORMAT_ERROR.getMessage());
        }
        AdminMember adminMemberByWrapper = this.adminMemberGateway.getAdminMemberByWrapper((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminMember::getPhone, (Object)phone)).eq(AdminMember::getNaCode, (Object)naCode)).eq(CommonEntity::getTenantId, (Object)tenantId)).eq(AdminMember::getIsConfirm, (Object)IsConfimEnum.AGREE.getStatus()));
        if (!Objects.isNull(adminMemberByWrapper)) {
            throw new BaseBusinessException(CommonEnum.MEMBER_IS_ABSENT.getCode(), CommonEnum.MEMBER_IS_ABSENT.getMessage());
        }
        AdminMember adminMember = new AdminMember();
        BeanUtils.copyProperties((Object)adminMeberCmd, (Object)adminMember);
        adminMember.setTenantId(tenantId);
        this.adminMemberGateway.insert(adminMember);
        this.commonService.insertMessage(adminMember.getId(), userId, tenantId);
        for (Long roleId : roleIdList) {
            AdminMemberRoleRel adminMemberRoleRel = new AdminMemberRoleRel();
            adminMemberRoleRel.setMemberId(adminMember.getId());
            adminMemberRoleRel.setRoleId(roleId);
            adminMemberRoleRel.setTenantId(user.getTenantId());
            this.adminMemberGateway.insertAdminMemberRoleRel(adminMemberRoleRel);
        }
    }
}

