/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.login;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.SmsCodeTypeEnum;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.LoginCmd;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.admin.utils.CodeUtils;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginSendSmsCodeCmdExe {
    private static final Logger log = LoggerFactory.getLogger(LoginSendSmsCodeCmdExe.class);
    @Autowired
    CommonService commonService;
    @Autowired
    private RedisDao redisDao;
    @Autowired
    AdminUserGateway adminUserGateway;

    public void execute(LoginCmd cmd) {
        try {
            String phone = cmd.getPhone();
            String smsCodeType = cmd.getSmsCodeType();
            String naCode = cmd.getNaCode();
            if (StringUtils.isBlank((String)smsCodeType)) {
                throw new BaseBusinessException(CommonEnum.SMS_CODE_TYPE_IS_NULL.getCode(), CommonEnum.SMS_CODE_TYPE_IS_NULL.getMessage());
            }
            if (StringUtils.isBlank((String)phone)) {
                throw new BaseBusinessException(CommonEnum.PHONE_IS_NULL.getCode(), CommonEnum.PHONE_IS_NULL.getMessage());
            }
            if (!Pattern.compile("^1([34578])\\d{9}$").matcher(phone).find()) {
                throw new BaseBusinessException(CommonEnum.PHONE_FORMAT_ERROR.getCode(), CommonEnum.PHONE_FORMAT_ERROR.getMessage());
            }
            AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminUser::getPhone, (Object)phone)).eq(AdminUser::getNaCode, (Object)naCode));
            if (com.google.common.base.Objects.equal((Object)SmsCodeTypeEnum.USER_REGIS_TYPE.getCodeType(), (Object)cmd.getSmsCodeType()) && !Objects.isNull(adminUser)) {
                throw new BaseBusinessException(CommonEnum.PHONE_IS_EXIST.getCode(), String.format(CommonEnum.PHONE_IS_EXIST.getMessage(), phone));
            }
            String smsCode = CodeUtils.generateCode();
            smsCode = "123456";
            log.info("\u9a8c\u8bc1\u7801:{}", (Object)smsCode);
            this.redisDao.put(this.commonService.getSmsCodeKey(smsCodeType, naCode + phone), (Object)smsCode, 300L);
        }
        catch (BaseBusinessException e) {
            throw new BaseBusinessException(e.getCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u9a8c\u8bc1\u7801\u9519\u8bef:{}", (Throwable)e);
            throw new BaseBusinessException(CommonEnum.FAILED.getCode(), CommonEnum.FAILED.getMessage());
        }
    }
}

