/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.login;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.cicv.foton.admin.domain.constants.Constant;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.SmsCodeTypeEnum;
import com.cicv.foton.admin.domain.gateway.AdminMemberGateway;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.gateway.TenantGateway;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.domain.system.Tenant;
import com.cicv.foton.admin.dto.LoginCmd;
import com.cicv.foton.admin.dto.clientobject.LoginCO;
import com.cicv.foton.admin.dto.clientobject.SimpleUserVO;
import com.cicv.foton.admin.service.CommonService;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginCmdExe {
    private static final Logger log = LoggerFactory.getLogger(LoginCmdExe.class);
    @Autowired
    CommonService commonService;
    @Autowired
    AdminUserGateway adminUserGateway;
    @Autowired
    TenantGateway tenantGateway;
    @Autowired
    AdminMemberGateway adminMemberGateway;
    @Autowired
    RedisDao redisDao;

    public LoginCO execute(LoginCmd cmd) {
        LoginCO loginCO = new LoginCO();
        try {
            AdminUser adminUser = this.loginHandle(cmd);
            SimpleUserVO userVO = new SimpleUserVO();
            Long id = adminUser.getId();
            BeanUtils.copyProperties((Object)adminUser, (Object)userVO);
            userVO.setUserId(id.longValue());
            loginCO.setTicket(adminUser.getTicket());
            List<Tenant> tennatList = this.commonService.getTenatInfo(id);
            loginCO.setUser(userVO);
            if (tennatList.size() < Constant.TENANT_SELECT_MIN_COUNT || StringUtils.isNotBlank((String)cmd.getTenantUrl())) {
                this.commonService.buildLoginInfo(loginCO, adminUser, tennatList.isEmpty() ? null : tennatList.get(0).getMemberId());
            } else {
                loginCO.setToken(this.commonService.generateToken(null, null, adminUser));
            }
            loginCO.setTenantList(tennatList);
            loginCO.setUserId(id);
        }
        catch (BaseBusinessException e) {
            throw new BaseBusinessException(e.getCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u767b\u5f55\u9519\u8bef:{}", (Throwable)e);
            throw new BaseBusinessException(CommonEnum.FAILED.getCode(), CommonEnum.FAILED.getMessage());
        }
        return loginCO;
    }

    private AdminUser loginHandle(LoginCmd cmd) {
        Integer type = cmd.getType();
        String phone = cmd.getPhone();
        String password = cmd.getPassword();
        String naCode = cmd.getNaCode();
        String verificationCode = cmd.getInputCode();
        if (Objects.isNull(type)) {
            throw new BaseBusinessException(CommonEnum.LOGIN_TYPE_IS_NULL.getCode(), CommonEnum.LOGIN_TYPE_IS_NULL.getMessage());
        }
        if (StringUtils.isBlank((String)phone)) {
            throw new BaseBusinessException(CommonEnum.PHONE_IS_NULL.getCode(), CommonEnum.PHONE_IS_NULL.getMessage());
        }
        if (!Pattern.compile("^1([34578])\\d{9}$").matcher(phone).find()) {
            throw new BaseBusinessException(CommonEnum.PHONE_FORMAT_ERROR.getCode(), CommonEnum.PHONE_FORMAT_ERROR.getMessage());
        }
        if (StringUtils.isBlank((String)naCode)) {
            throw new BaseBusinessException(CommonEnum.PHONE_IS_NULL.getCode(), CommonEnum.PHONE_IS_NULL.getMessage());
        }
        AdminUser adminUser = new AdminUser();
        switch (type) {
            case 1: {
                this.checkVerificationCode(cmd.getCaptchaKey(), verificationCode);
                adminUser = this.commonService.getAdminUser((LambdaQueryWrapper<AdminUser>)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminUser::getPhone, (Object)phone)).eq(AdminUser::getNaCode, (Object)naCode)));
                String ticket = this.loginByPassword(password, adminUser);
                adminUser.setTicket(ticket);
                break;
            }
            case 2: {
                adminUser = this.commonService.getAdminUser((LambdaQueryWrapper<AdminUser>)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminUser::getPhone, (Object)phone)).eq(AdminUser::getNaCode, (Object)naCode)));
                this.commonService.checkPhoneCode(naCode + phone, SmsCodeTypeEnum.VERIFY_CODE_LOGIN.getCodeType(), verificationCode);
                break;
            }
            case 3: {
                break;
            }
        }
        return adminUser;
    }

    private void checkVerificationCode(String captchaKey, String verificationCode) {
        if (StringUtils.isBlank((String)captchaKey) || StringUtils.isBlank((String)verificationCode)) {
            throw new BaseBusinessException(CommonEnum.LOGIN_PIC_VERIFY_CODE_IS_NULL.getCode(), CommonEnum.LOGIN_PIC_VERIFY_CODE_IS_NULL.getMessage());
        }
        if (!this.verificationCaptcha(captchaKey, verificationCode)) {
            throw new BaseBusinessException(CommonEnum.LOGIN_PIC_VERIFY_CODE_IS_ERROR.getCode(), CommonEnum.LOGIN_PIC_VERIFY_CODE_IS_ERROR.getMessage());
        }
    }

    private String loginByPassword(String password, AdminUser adminUser) {
        if (!Objects.equals(password, adminUser.getPassword())) {
            throw new BaseBusinessException(CommonEnum.PASSWORD_IS_ERROR.getCode(), CommonEnum.PASSWORD_IS_ERROR.getMessage());
        }
        return this.isUpdatePassword(adminUser);
    }

    private boolean verificationCaptcha(String captchaKey, String inputCode) {
        String redisCode;
        try {
            String redisKey = "spatiotemporal:captcha:image:" + captchaKey;
            redisCode = this.redisDao.getString(redisKey);
            this.redisDao.del(new String[]{redisKey});
        }
        catch (Exception e) {
            log.error("verificationCaptcha \u8bf7\u6c42redis\u5931\u8d25 error:", (Throwable)e);
            throw new BaseBusinessException(ReturnEnum.FAILED);
        }
        if (inputCode.toLowerCase().equals(redisCode)) {
            return true;
        }
        log.info("verificationCaptcha false . param captchaKey:{} , input code:{} , redis code:{} ", new Object[]{captchaKey, inputCode, redisCode});
        return false;
    }

    private String isUpdatePassword(AdminUser adminUser) {
        String ticket = null;
        if (Objects.isNull(adminUser.getLastLoginTime())) {
            ticket = UUID.randomUUID().toString().replace("-", "");
            this.redisDao.put("foton:reset:password:" + adminUser.getNaCode() + adminUser.getPhone() + ":" + ticket, (Object)ticket, 36000L);
        } else {
            this.adminUserGateway.updateUserInfo((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(AdminUser::getLastLoginTime, (Object)new Date())).eq(BaseEntity::getId, (Object)adminUser.getId()));
        }
        return ticket;
    }
}

