/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.idm;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.dto.IdmCmd;
import com.inzyme.spatiotemporal.web.core.domain.entity.BaseEntity;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IdmUserInfoEntryCmdExe {
    private static final Logger log = LoggerFactory.getLogger(IdmUserInfoEntryCmdExe.class);
    @Autowired
    AdminUserGateway adminUserGateway;

    public void execute(IdmCmd cmd) {
        Long id = cmd.getId();
        String name = cmd.getName();
        String mail = cmd.getMail();
        if (Objects.isNull(id) || StringUtils.isBlank((String)name) || StringUtils.isBlank((String)mail)) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)id));
        if (Objects.isNull(adminUser)) {
            throw new BaseBusinessException(CommonEnum.USER_ABSENT.getCode(), CommonEnum.USER_ABSENT.getMessage());
        }
        adminUser.setRealName(name);
        adminUser.setMailBox(mail);
        this.adminUserGateway.updateAdminUser(adminUser);
    }
}

