/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.commond.idm;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cicv.foton.admin.domain.enums.BooleanEnum;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.enums.SmsCodeTypeEnum;
import com.cicv.foton.admin.domain.gateway.AdminUserGateway;
import com.cicv.foton.admin.domain.system.AdminIdmUser;
import com.cicv.foton.admin.domain.system.AdminUser;
import com.cicv.foton.admin.domain.system.dataobject.IdmUserDO;
import com.cicv.foton.admin.dto.IdmCmd;
import com.cicv.foton.admin.service.CommonService;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IdmLoginInfoEntryCmdExe {
    private static final Logger log = LoggerFactory.getLogger(IdmLoginInfoEntryCmdExe.class);
    @Autowired
    AdminUserGateway adminUserGateway;
    @Autowired
    CommonService commonService;

    public IdmUserDO execute(IdmCmd cmd) {
        String phone = cmd.getPhone();
        String naCode = cmd.getNaCode();
        String password = cmd.getPassword();
        String inputCode = cmd.getInputCode();
        String userId = cmd.getUserId();
        if (StringUtils.isBlank((String)userId) || StringUtils.isBlank((String)phone) || StringUtils.isBlank((String)naCode) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)inputCode)) {
            throw new BaseBusinessException(CommonEnum.ERROR_POST_PARAM.getCode(), CommonEnum.ERROR_POST_PARAM.getMessage());
        }
        if (!Pattern.compile("^1([34578])\\d{9}$").matcher(phone).find()) {
            throw new BaseBusinessException(CommonEnum.PHONE_FORMAT_ERROR.getCode(), CommonEnum.PHONE_FORMAT_ERROR.getMessage());
        }
        this.commonService.checkPhoneCode(naCode + phone, SmsCodeTypeEnum.IDM_INFO_ENTER.getCodeType(), inputCode);
        IdmUserDO idmUserDO = new IdmUserDO();
        AdminIdmUser adminIdmUser = this.adminUserGateway.getIdmUserById(userId);
        if (Objects.isNull(adminIdmUser)) {
            throw new BaseBusinessException(CommonEnum.IDM_PHONE_IS_ABSENT.getCode(), CommonEnum.IDM_PHONE_IS_ABSENT.getMessage());
        }
        AdminUser adminUser = this.adminUserGateway.selectUserInfo((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdminUser::getPhone, (Object)phone)).eq(AdminUser::getNaCode, (Object)naCode));
        if (Objects.isNull(adminUser)) {
            this.insertIdmUserInfo(adminIdmUser, phone, naCode, password);
        }
        String queryIdmAccount = adminUser.getIdmAccount();
        idmUserDO.setId(adminUser.getId());
        if (StringUtils.isBlank((String)queryIdmAccount)) {
            adminUser.setIdmAccount(userId);
            this.adminUserGateway.updateAdminUser(adminUser);
        } else if (!Objects.equals(userId, queryIdmAccount)) {
            throw new BaseBusinessException(CommonEnum.IDM_PHONE_IS_USED.getCode(), CommonEnum.IDM_PHONE_IS_USED.getMessage());
        }
        this.buildIdmUserDO(idmUserDO, adminUser, adminIdmUser);
        return null;
    }

    private void insertIdmUserInfo(AdminIdmUser adminIdmUser, String phone, String naCode, String password) {
        AdminUser adminUser = new AdminUser();
        adminUser.setIdmAccount(adminIdmUser.getUserID());
        adminUser.setMailBox(adminIdmUser.getMail());
        adminUser.setPassword(password);
        adminUser.setPhone(phone);
        adminUser.setNaCode(naCode);
        adminUser.setUserName(password);
        adminUser.setRealName(adminIdmUser.getName());
        adminUser.setLastLoginTime(new Date());
        this.adminUserGateway.insertAdminUser(adminUser);
    }

    private void buildIdmUserDO(IdmUserDO idmUserDO, AdminUser adminUser, AdminIdmUser adminIdmUser) {
        boolean flag = BooleanEnum.FALSE.isFlag();
        String realName = adminUser.getRealName();
        String mailBox = adminUser.getMailBox();
        String name = adminIdmUser.getName();
        String mail = adminIdmUser.getMail();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> mailList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)realName)) {
            nameList.add(realName);
        }
        if (StringUtils.isNotBlank((String)name) && !nameList.isEmpty() && !Objects.equals(name, nameList.get(0))) {
            nameList.add(realName);
        }
        if (StringUtils.isNotBlank((String)mailBox)) {
            mailList.add(mailBox);
        }
        if (StringUtils.isNotBlank((String)mail) && !mailList.isEmpty() && !Objects.equals(name, mailList.get(0))) {
            mailList.add(mail);
        }
        if (nameList.size() + mailList.size() > 2) {
            idmUserDO.setNameList(nameList);
            idmUserDO.setMailList(mailList);
            flag = BooleanEnum.TRUE.isFlag();
        }
        idmUserDO.setIsUserEnter(Boolean.valueOf(flag));
    }
}

